/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.Namespaces;
import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.SourceInfo;
import com.alibaba.citrus.springext.impl.SchemaImpl;
import com.alibaba.citrus.springext.support.ClasspathResourceResolver;
import com.alibaba.citrus.springext.support.SourceInfoSupport;
import com.alibaba.citrus.springext.support.SpringSchemasSourceInfo;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringPluggableSchemas
implements Schemas,
Namespaces {
    private static final Logger log = LoggerFactory.getLogger(SpringPluggableSchemas.class);
    private static final String SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final String HANDLER_MAPPINGS_LOCATION = "META-INF/spring.handlers";
    private static final String TOOLING_PARAMS_LOCATION = "META-INF/spring.tooling";
    private static final Pattern SCHEMA_VERSION_PATTERN = Pattern.compile("-((\\d+)(.\\d+)*)\\.xsd$");
    private final ResourceResolver resourceResolver;
    private final Map<String, Schema> nameToSchemaMappings;
    private final Map<String, String> uriToNameMappings;
    private final Set<String> namespaces;
    private final Set<String> namespacesUnmodified;
    private final Map<String, Map<String, String>> toolingParameters;
    private boolean initialized;

    public SpringPluggableSchemas() {
        this(null, null);
    }

    public SpringPluggableSchemas(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public SpringPluggableSchemas(ResourceResolver resourceResolver) {
        this(null, Assert.assertNotNull(resourceResolver, "no resourceResolver was specified", new Object[0]));
    }

    private SpringPluggableSchemas(ClassLoader classLoader, ResourceResolver resourceResolver) {
        if (resourceResolver == null) {
            if (classLoader == null) {
                classLoader = ClassUtils.getDefaultClassLoader();
            }
            this.resourceResolver = new ClasspathResourceResolver(classLoader);
        } else {
            this.resourceResolver = resourceResolver;
        }
        this.nameToSchemaMappings = CollectionUtil.createTreeMap();
        this.uriToNameMappings = CollectionUtil.createTreeMap();
        this.namespaces = CollectionUtil.createTreeSet();
        this.namespacesUnmodified = Collections.unmodifiableSet(this.namespaces);
        this.toolingParameters = CollectionUtil.createHashMap();
    }

    @Override
    public Set<String> getAvailableNamespaces() {
        this.ensureInit();
        return this.namespacesUnmodified;
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        this.ensureInit();
        return this.nameToSchemaMappings;
    }

    public Map<String, String> getUriToNameMappings() {
        this.ensureInit();
        return this.uriToNameMappings;
    }

    public Map<String, String> getToolingParameters(String namespaceURI) {
        this.ensureInit();
        return this.toolingParameters.get(StringUtil.trimToNull(namespaceURI));
    }

    private void ensureInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.trace("Trying to load Spring schema mappings at {}", (Object)SCHEMA_MAPPINGS_LOCATION);
        String desc = "SpringSchema[META-INF/spring.schemas]";
        this.resourceResolver.loadAllProperties(TOOLING_PARAMS_LOCATION, new ResourceResolver.PropertyHandler(){

            public void handle(String key, String value, ResourceResolver.Resource source, int lineNumber) {
                String namespaceAndParamName = StringUtil.trimToNull(key);
                if (namespaceAndParamName != null) {
                    int index = namespaceAndParamName.indexOf("@");
                    String namespace = null;
                    String paramName = null;
                    if (index >= 0) {
                        namespace = StringUtil.trimToNull(namespaceAndParamName.substring(0, index));
                        paramName = StringUtil.trimToNull(namespaceAndParamName.substring(index + 1));
                    }
                    if (namespace != null && paramName != null) {
                        HashMap<String, String> params = (HashMap<String, String>)SpringPluggableSchemas.this.toolingParameters.get(namespace);
                        if (params == null) {
                            params = CollectionUtil.createHashMap();
                            SpringPluggableSchemas.this.toolingParameters.put(namespace, params);
                        }
                        params.put(paramName, StringUtil.trimToNull(value));
                    }
                }
            }
        });
        this.resourceResolver.loadAllProperties(SCHEMA_MAPPINGS_LOCATION, new ResourceResolver.PropertyHandler(){

            public void handle(String key, String value, ResourceResolver.Resource source, int lineNumber) {
                String uri = StringUtil.trimToNull(key);
                String classpathLocation = StringUtil.trimToNull(value);
                if (uri == null || classpathLocation == null) {
                    return;
                }
                String schemaName = SpringPluggableSchemas.this.getSchemaName(uri);
                Matcher matcher = SCHEMA_VERSION_PATTERN.matcher(schemaName);
                String version = null;
                if (matcher.find()) {
                    version = matcher.group(1);
                }
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class SpringSchemasSourceInfoImpl
                extends SourceInfoSupport<SourceInfo<?>>
                implements SpringSchemasSourceInfo {
                    SpringSchemasSourceInfoImpl() {
                    }
                }
                SpringSchemasSourceInfoImpl pluginSourceInfo = new SpringSchemasSourceInfoImpl();
                pluginSourceInfo.setSource(source, lineNumber);
                ResourceResolver.Resource schemaSource = SpringPluggableSchemas.this.getResource(classpathLocation, uri);
                if (schemaSource != null) {
                    Schema schema = SchemaImpl.createSpringPluggableSchema(schemaName, version, true, "SpringSchema[META-INF/spring.schemas]", schemaSource, new SourceInfoSupport<SpringSchemasSourceInfoImpl>(pluginSourceInfo).setSource(schemaSource), SpringPluggableSchemas.this.toolingParameters);
                    SpringPluggableSchemas.this.nameToSchemaMappings.put(schemaName, schema);
                    SpringPluggableSchemas.this.uriToNameMappings.put(uri, schemaName);
                    String namespace = schema.getTargetNamespace();
                    if (namespace != null) {
                        SpringPluggableSchemas.this.namespaces.add(namespace);
                    }
                }
            }
        });
        this.resourceResolver.loadAllProperties(HANDLER_MAPPINGS_LOCATION, new ResourceResolver.PropertyHandler(){

            public void handle(String key, String value, ResourceResolver.Resource source, int lineNumber) {
                String namespace = StringUtil.trimToNull(key);
                if (namespace != null) {
                    SpringPluggableSchemas.this.namespaces.add(namespace);
                }
            }
        });
        if (log.isDebugEnabled() && !this.uriToNameMappings.isEmpty()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Loaded Spring schema mappings at %s, %d schemas found.", SCHEMA_MAPPINGS_LOCATION, this.uriToNameMappings.size()).appendMap(this.uriToNameMappings);
            log.debug(buf.toString());
        }
    }

    private ResourceResolver.Resource getResource(String classpathLocation, String uri) {
        ResourceResolver.Resource resource = this.resourceResolver.getResource(classpathLocation);
        if (resource == null) {
            log.warn("Could not find schema {} for URI: {}", (Object)classpathLocation, (Object)uri);
        }
        return resource;
    }

    private String getSchemaName(String uri) {
        return URI.create(uri).normalize().getSchemeSpecificPart().replaceAll("^/+|/+$", "");
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("SpringPluggableSchemas[loaded from %s]", SCHEMA_MAPPINGS_LOCATION);
        buf.appendMap(this.uriToNameMappings);
        return buf.toString();
    }
}

