/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.component.KeyValuesComponent;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class SystemPropertiesComponent
extends PageComponent {
    private static final Set<String> PATH_LIKE_KEYS = CollectionUtil.createHashSet("java.class.path", "java.endorsed.dirs", "java.ext.dirs", "java.library.path", "sun.boot.class.path", "sun.boot.library.path");
    private final KeyValuesComponent keyValuesComponent;

    public SystemPropertiesComponent(PageComponentRegistry registry, String componentPath, KeyValuesComponent keyValuesComponent) {
        super(registry, componentPath);
        this.keyValuesComponent = keyValuesComponent;
    }

    public void visitTemplate(RequestHandlerContext context) {
        this.getTemplate().accept(new SystemPropertiesVisitor(context));
    }

    private class SystemPropertiesVisitor
    extends AbstractVisitor {
        private final Properties props;

        public SystemPropertiesVisitor(RequestHandlerContext context) {
            super(context, SystemPropertiesComponent.this);
            this.props = System.getProperties();
        }

        public void visitProperties() {
            TreeMap<String, String> keyValues = CollectionUtil.createTreeMap();
            String pathSep = this.props.getProperty("path.separator");
            for (Object key : this.props.keySet()) {
                Object value = StringEscapeUtil.escapeJava(this.props.getProperty(String.valueOf(key)));
                if (PATH_LIKE_KEYS.contains(key)) {
                    value = CollectionUtil.createArrayList(StringUtil.split((String)value, pathSep));
                }
                keyValues.put(String.valueOf(key), (String)value);
            }
            SystemPropertiesComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }
    }
}

