/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.regex;

import com.alibaba.citrus.util.Assert;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PathNameWildcardCompiler {
    public static final int FORCE_ABSOLUTE_PATH = 4096;
    public static final int FORCE_RELATIVE_PATH = 8192;
    public static final int FORCE_MATCH_PREFIX = 16384;
    private static final char ESCAPE_CHAR = '\\';
    private static final char SLASH = '/';
    private static final char UNDERSCORE = '_';
    private static final char DASH = '-';
    private static final char DOT = '.';
    private static final char STAR = '*';
    private static final char QUESTION = '?';
    private static final String REGEX_MATCH_PREFIX = "^";
    private static final String REGEX_WORD_BOUNDARY = "\\b";
    private static final String REGEX_SLASH = "\\/";
    private static final String REGEX_SLASH_NO_DUP = "\\/(?!\\/)";
    private static final String REGEX_FILE_NAME_CHAR = "[\\w\\-\\.]";
    private static final String REGEX_FILE_NAME_SINGLE_CHAR = "([\\w\\-\\.])";
    private static final String REGEX_FILE_NAME = "([\\w\\-\\.]*)";
    private static final String REGEX_FILE_PATH = "([\\w\\-\\.]+(?:\\/(?!\\/)[\\w\\-\\.]*)*(?=\\/|$)|)\\/?";
    private static final int LAST_TOKEN_START = 0;
    private static final int LAST_TOKEN_SLASH = 1;
    private static final int LAST_TOKEN_FILE_NAME = 2;
    private static final int LAST_TOKEN_STAR = 3;
    private static final int LAST_TOKEN_DOUBLE_STAR = 4;
    private static final int LAST_TOKEN_QUESTION = 5;

    private PathNameWildcardCompiler() {
    }

    public static Pattern compilePathName(String pattern) throws PatternSyntaxException {
        return PathNameWildcardCompiler.compilePathName(pattern, 0);
    }

    public static Pattern compilePathName(String pattern, int options) throws PatternSyntaxException {
        return Pattern.compile(PathNameWildcardCompiler.pathNameToRegex(pattern, options), options);
    }

    public static int getPathNameRelevancy(String pattern) {
        if ((pattern = PathNameWildcardCompiler.normalizePathName(pattern)) == null) {
            return 0;
        }
        int relevant = 0;
        block3: for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '*': 
                case '/': 
                case '?': {
                    continue block3;
                }
                default: {
                    ++relevant;
                }
            }
        }
        return relevant;
    }

    public static String pathNameToRegex(String pattern, int options) throws PatternSyntaxException {
        boolean forceRelativePath;
        pattern = Assert.assertNotNull(PathNameWildcardCompiler.normalizePathName(pattern), "pattern", new Object[0]);
        int lastToken = 0;
        StringBuilder buf = new StringBuilder(pattern.length() * 2);
        boolean forceMatchPrefix = (options & 0x4000) != 0;
        boolean forceAbsolutePath = (options & 0x1000) != 0;
        boolean bl = forceRelativePath = (options & 0x2000) != 0;
        if (forceMatchPrefix || pattern.length() > 0 && pattern.charAt(0) == '/') {
            buf.append(REGEX_MATCH_PREFIX);
        }
        if (pattern.length() == 1 && pattern.charAt(0) == '/') {
            pattern = "";
        }
        block5: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (forceAbsolutePath && lastToken == 0 && ch != '/') {
                throw new PatternSyntaxException("Syntax Error", pattern, i);
            }
            switch (ch) {
                case '/': {
                    if (lastToken == 1) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    if (forceRelativePath && lastToken == 0) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    if (lastToken != 4) {
                        buf.append(REGEX_SLASH_NO_DUP);
                    }
                    lastToken = 1;
                    continue block5;
                }
                case '*': {
                    int j = i + 1;
                    if (j < pattern.length() && pattern.charAt(j) == '*') {
                        i = j;
                        if (lastToken != 0 && lastToken != 1) {
                            throw new PatternSyntaxException("Syntax Error", pattern, i);
                        }
                        lastToken = 4;
                        buf.append(REGEX_FILE_PATH);
                        continue block5;
                    }
                    if (lastToken == 3 || lastToken == 4) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    lastToken = 3;
                    buf.append(REGEX_FILE_NAME);
                    continue block5;
                }
                case '?': {
                    lastToken = 5;
                    buf.append(REGEX_FILE_NAME_SINGLE_CHAR);
                    continue block5;
                }
                default: {
                    if (lastToken == 4) {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '-') {
                        if (lastToken == 0) {
                            buf.append(REGEX_WORD_BOUNDARY).append(ch);
                        } else if (i + 1 == pattern.length()) {
                            buf.append(ch).append(REGEX_WORD_BOUNDARY);
                        } else {
                            buf.append(ch);
                        }
                    } else if (ch == '.') {
                        buf.append('\\').append('.');
                    } else {
                        throw new PatternSyntaxException("Syntax Error", pattern, i);
                    }
                    lastToken = 2;
                }
            }
        }
        return buf.toString();
    }

    public static String normalizePathName(String name) {
        if (name == null) {
            return null;
        }
        return name.trim().replaceAll("[/\\\\]+", "/");
    }
}

