/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.util;

import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.service.moduleloader.Module;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderService;
import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.service.template.Renderable;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateService;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.support.ContextAdapter;
import com.alibaba.citrus.turbine.support.MappedContext;
import com.alibaba.citrus.turbine.util.ControlToolConfiguration;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.WebxException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Element;

public class ControlTool
extends ControlToolConfiguration
implements Renderable {
    private static final Logger log = LoggerFactory.getLogger(ControlTool.class);
    private final ErrorHandler errorHandler;
    private LinkedList<ControlParameters> controlParameterStack = CollectionUtil.createLinkedList();

    public ControlTool() {
        this((ErrorHandler)null);
    }

    public ControlTool(boolean productionMode) {
        this(productionMode ? ErrorDetailLevel.messageOnly : ErrorDetailLevel.stackTrace);
    }

    public ControlTool(ErrorDetailLevel errorDetailLevel) {
        this(errorDetailLevel == null ? null : errorDetailLevel.getHandler());
    }

    public ControlTool(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = ErrorDetailLevel.messageOnly.getHandler();
        }
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public ControlTool setTemplate(String template) {
        ControlParameters params = this.getControlParameters();
        if (params.module == null) {
            params.template = template;
        }
        return this;
    }

    public ControlTool setModule(String module) {
        ControlParameters params = this.getControlParameters();
        if (params.template == null) {
            params.module = module;
        }
        return this;
    }

    public ControlTool setParameter(String name, Object value) {
        ControlParameters params = this.getControlParameters();
        params.put(name, value);
        return this;
    }

    public ControlTool export(String ... vars) {
        ControlParameters params = this.getControlParameters();
        params.exportVars = CollectionUtil.createHashSet(vars);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render() {
        String content;
        this.assertInitialized();
        ControlParameters params = this.getControlParameters();
        String target = null;
        try {
            boolean isTemplate;
            String componentName;
            if (params.template != null) {
                componentName = this.parseComponentName(params.template);
                target = this.parseLocalName(params.template);
                isTemplate = true;
            } else if (params.module != null) {
                componentName = this.parseComponentName(params.module);
                target = this.parseLocalName(params.module);
                isTemplate = false;
            } else {
                throw new IllegalArgumentException("Neither template nor module name was specified to render a control");
            }
            ModuleLoaderService moduleLoaderService = this.getService("moduleLoaderService", componentName, this.moduleLoaderService, ModuleLoaderService.class);
            MappingRuleService mappingRuleService = this.getService("mappingRuleService", componentName, this.mappingRuleService, MappingRuleService.class);
            TemplateService templateService = this.getService("templateService", componentName, this.templateService, TemplateService.class);
            String templateName = null;
            String moduleName = null;
            if (isTemplate) {
                templateName = target;
                moduleName = mappingRuleService.getMappedName("control", target);
            } else {
                moduleName = mappingRuleService.getMappedName("control.notemplate", target);
            }
            Module controlModule = templateName == null ? moduleLoaderService.getModule("control", moduleName) : moduleLoaderService.getModuleQuiet("control", moduleName);
            if (log.isTraceEnabled()) {
                if (templateName != null) {
                    log.trace("Rendering control: template=" + templateName + ", control=" + moduleName);
                } else {
                    log.trace("Rendering control without template: control=" + moduleName);
                }
            }
            this.bufferedRequestContext.pushBuffer();
            try {
                this.controlParameterStack.addFirst(new ControlParameters());
                TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
                Context contextForControl = this.createContextForControl(params, componentName);
                rundata.pushContext(contextForControl, templateName);
                try {
                    String templateOverriden;
                    if (controlModule != null) {
                        controlModule.execute();
                    }
                    if (!ObjectUtil.isEquals(templateOverriden = rundata.getControlTemplate(), templateName)) {
                        log.debug("Control template has been changed by module: " + templateName + " -> " + templateOverriden);
                        templateName = templateOverriden;
                    }
                    if (templateName != null) {
                        templateName = mappingRuleService.getMappedName("control.template", templateName);
                    }
                    if (templateName != null) {
                        templateService.writeTo(templateName, (TemplateContext)new ContextAdapter(contextForControl), rundata.getResponse().getWriter());
                    }
                }
                finally {
                    rundata.popContext();
                }
            }
            finally {
                this.controlParameterStack.removeFirst();
                content = this.bufferedRequestContext.popCharBuffer();
            }
        }
        catch (Exception e) {
            content = null;
            try {
                content = this.errorHandler.handleException(target, e);
            }
            catch (RuntimeException ee) {
                // empty catch block
            }
            if (content == null) {
                throw new WebxException("Failed to execute control module: " + target, e);
            }
            log.error("Failed to execute control module: " + target, (Throwable)e);
        }
        finally {
            params.template = null;
            params.module = null;
            params.exportVars = null;
            params.clear();
        }
        return content;
    }

    private String parseComponentName(String name) {
        int index;
        int n = index = name == null ? -1 : name.indexOf(":");
        if (index >= 0) {
            return StringUtil.trimToNull(name.substring(0, index));
        }
        return null;
    }

    private String parseLocalName(String name) {
        int index;
        int n = index = name == null ? -1 : name.indexOf(":");
        if (index >= 0) {
            return StringUtil.trimToNull(name.substring(index + 1));
        }
        return StringUtil.trimToNull(name);
    }

    private <T> T getService(String name, String componentName, T defaultService, Class<T> serviceType) {
        if (componentName == null) {
            return defaultService;
        }
        WebApplicationContext context = Assert.assertNotNull(this.components.getComponent(componentName), "invalid prefix \"%s:\", component does not exist", componentName).getApplicationContext();
        try {
            return serviceType.cast(context.getBean(name, serviceType));
        }
        catch (BeansException e) {
            throw new IllegalArgumentException(String.format("Could not get service: \"%s:%s\"", componentName, serviceType.getSimpleName()), e);
        }
    }

    private Context createContextForControl(ControlParameters params, String componentName) {
        TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
        Context screenContext = rundata.getContext(componentName);
        final Context callerContext = rundata.getCurrentContext();
        final Set exportVars = params.exportVars == null ? Collections.emptySet() : params.exportVars;
        MappedContext context = new MappedContext(screenContext){

            @Override
            protected void internalPut(String key, Object value) {
                if (this.isExport(key)) {
                    callerContext.put(key, value);
                }
                super.internalPut(key, value);
            }

            @Override
            protected void internalRemove(String key) {
                if (this.isExport(key)) {
                    callerContext.remove(key);
                }
                super.internalRemove(key);
            }

            private boolean isExport(String key) {
                return callerContext != null && (ControlTool.this.exportAll || exportVars.contains(key));
            }
        };
        context.getMap().putAll(params);
        return context;
    }

    protected ControlParameters getControlParameters() {
        if (this.controlParameterStack.isEmpty()) {
            this.controlParameterStack.addFirst(new ControlParameters());
        }
        return this.controlParameterStack.getFirst();
    }

    public static class Factory
    extends ControlToolConfiguration
    implements ToolFactory,
    ProductionModeAware {
        private ErrorDetailLevel errorDetailLevel;
        private ErrorHandler errorHandler;
        private boolean productionMode = true;
        private boolean exportAll;

        @Override
        public void setProductionMode(boolean productionMode) {
            this.productionMode = productionMode;
        }

        public void setErrorDetailLevel(ErrorDetailLevel errorDetailLevel) {
            this.errorDetailLevel = errorDetailLevel;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public void setExportAll(boolean exportAll) {
            this.exportAll = exportAll;
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public Object createTool() throws Exception {
            ControlTool tool = this.errorDetailLevel != null ? new ControlTool(this.errorDetailLevel) : (this.errorHandler != null ? new ControlTool(this.errorHandler) : new ControlTool(this.productionMode));
            tool.init(this.components, this.moduleLoaderService, this.mappingRuleService, this.templateService, this.request, this.bufferedRequestContext);
            tool.exportAll = this.exportAll;
            tool.afterPropertiesSet();
            return tool;
        }
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<Factory> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String errorDetailLevel = StringUtil.trimToNull(element.getAttribute("detailLevel"));
            if (errorDetailLevel != null) {
                builder.addPropertyValue("errorDetailLevel", (Object)errorDetailLevel);
            } else {
                Element errorHandlerElement = DomUtil.theOnlySubElement(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("errorHandler")));
                if (errorHandlerElement != null) {
                    builder.addPropertyValue("errorHandler", SpringExtUtil.parseBean(errorHandlerElement, parserContext, (BeanDefinition)builder.getRawBeanDefinition()));
                }
            }
            String exportAll = StringUtil.trimToNull(element.getAttribute("exportAll"));
            if (exportAll != null) {
                builder.addPropertyValue("exportAll", (Object)exportAll);
            }
        }
    }

    public static class DefaultErrorHandler
    implements ErrorHandler {
        private String errorTagClass;
        private ErrorDetailLevel detailLevel;

        public DefaultErrorHandler() {
        }

        public DefaultErrorHandler(ErrorDetailLevel detailLevel) {
            this.detailLevel = detailLevel;
        }

        public String getErrorTagClass() {
            return ObjectUtil.defaultIfNull(this.errorTagClass, "webx.error");
        }

        public void setErrorTagClass(String errorTagClass) {
            this.errorTagClass = StringUtil.trimToNull(errorTagClass);
        }

        public ErrorDetailLevel getDetailLevel() {
            return this.detailLevel == null ? ErrorDetailLevel.messageOnly : this.detailLevel;
        }

        public void setDetailLevel(ErrorDetailLevel detailLevel) {
            this.detailLevel = detailLevel;
        }

        @Override
        public String handleException(String controlTarget, Exception e) {
            ErrorDetailLevel detailLevel = this.getDetailLevel();
            switch (detailLevel) {
                case throwException: {
                    return null;
                }
                case quiet: {
                    return "";
                }
            }
            StringWriter buf = new StringWriter();
            PrintWriter pw = new PrintWriter(buf);
            Formatter fmt = new Formatter(pw);
            fmt.format("<!-- control failed: target=%s, exceptionType=%s -->", controlTarget, e.getClass().getName());
            switch (detailLevel) {
                case messageOnly: {
                    fmt.format("<div class=\"%s\">", this.getErrorTagClass());
                    String msg = e.getMessage();
                    if (StringUtil.isEmpty(msg)) {
                        msg = e.getClass().getSimpleName();
                    }
                    pw.append(StringEscapeUtil.escapeHtml(msg));
                    pw.append("</div>");
                    break;
                }
                case stackTrace: {
                    fmt.format("<div class=\"%s\">", this.getErrorTagClass());
                    pw.append(ExceptionUtil.getStackTraceForHtmlComment(e));
                    pw.append("</div>");
                    break;
                }
                case comment: {
                    pw.append("<!-- stacktrace: \n");
                    pw.append(ExceptionUtil.getStackTraceForHtmlComment(e));
                    pw.append("-->");
                    break;
                }
                default: {
                    Assert.unreachableCode(detailLevel.name(), new Object[0]);
                }
            }
            pw.flush();
            return buf.toString();
        }
    }

    public static class ThrowError
    implements ErrorHandler {
        @Override
        public String handleException(String controlTarget, Exception e) {
            return null;
        }
    }

    public static interface ErrorHandler {
        public String handleException(String var1, Exception var2);
    }

    public static enum ErrorDetailLevel {
        throwException,
        quiet,
        messageOnly,
        stackTrace,
        comment;

        private final ErrorHandler handler = new DefaultErrorHandler(this);

        public ErrorHandler getHandler() {
            return this.handler;
        }
    }

    protected static class ControlParameters
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 3256721796996084529L;
        private String module;
        private String template;
        private Set<String> exportVars;

        public ControlParameters() {
            super(4);
        }
    }
}

