/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.util.ErrorHandlerHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class HandleExceptionValve
extends AbstractValve {
    private static final Logger log = LoggerFactory.getLogger(HandleExceptionValve.class);
    private static final String HELPER_NAME_DEFAULT = "error";
    private final HttpServletRequest request;
    private String defaultPage;
    private ExceptionHandler[] exceptionHandlers;
    private String helperName;
    private ErrorHandlerHelper.LoggingDetail defaultLoggingDetail;
    private Logger defaultLogger;

    public HandleExceptionValve(HttpServletRequest request) {
        this.request = Assert.assertNotNull(SpringExtUtil.assertProxy(request), "no request", new Object[0]);
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = StringUtil.trimToNull(defaultPage);
    }

    public void setDefaultLogging(ErrorHandlerHelper.LoggingDetail defaultLoggingDetail) {
        this.defaultLoggingDetail = defaultLoggingDetail;
    }

    public void setDefaultLoggerName(String defaultLoggerName) {
        if ((defaultLoggerName = StringUtil.trimToNull(defaultLoggerName)) != null) {
            this.defaultLogger = LoggerFactory.getLogger((String)defaultLoggerName);
        }
    }

    public void setExceptionHandlers(ExceptionHandler[] exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public void setHelperName(String helperName) {
        this.helperName = StringUtil.trimToNull(helperName);
    }

    @Override
    protected void init() throws Exception {
        Assert.assertNotNull(this.defaultPage, "no defaultPage", new Object[0]);
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ExceptionHandler[0];
        }
        if (this.defaultLoggingDetail == null) {
            this.defaultLoggingDetail = ErrorHandlerHelper.LoggingDetail.detailed;
        }
        if (this.defaultLogger == null) {
            this.defaultLogger = log;
        }
        for (ExceptionHandler handler : this.exceptionHandlers) {
            handler.init(this.defaultLoggingDetail, this.defaultLogger);
        }
        this.exceptionHandlers = this.sortExceptions(this.exceptionHandlers);
        if (this.helperName == null) {
            this.helperName = HELPER_NAME_DEFAULT;
        }
    }

    private ExceptionHandler[] sortExceptions(ExceptionHandler[] handlers) {
        HashSet<ExceptionHandler> visited = CollectionUtil.createHashSet();
        LinkedList<ExceptionHandler> sorted = CollectionUtil.createLinkedList();
        for (ExceptionHandler handler : handlers) {
            this.visitException(handler, handlers, visited, sorted);
        }
        return sorted.toArray(new ExceptionHandler[sorted.size()]);
    }

    private void visitException(ExceptionHandler handler, ExceptionHandler[] handlers, Set<ExceptionHandler> visited, List<ExceptionHandler> sorted) {
        if (visited.contains(handler)) {
            return;
        }
        visited.add(handler);
        for (ExceptionHandler test : handlers) {
            if (!handler.getExceptionType().isAssignableFrom(test.getExceptionType())) continue;
            this.visitException(test, handlers, visited, sorted);
        }
        sorted.add(handler);
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
        ErrorHandlerHelper helper = ErrorHandlerHelper.getInstance(this.request);
        Throwable exception = helper.getException();
        rundata.getContext().put(this.helperName, helper);
        if (exception != null) {
            int statusCode = -1;
            String target = null;
            ErrorHandlerHelper.LoggingDetail loggingDetail = this.defaultLoggingDetail;
            Logger logger = this.defaultLogger;
            block0: for (Throwable cause : ExceptionUtil.getCauses(exception, true)) {
                for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
                    if (!exceptionHandler.getExceptionType().isInstance(cause)) continue;
                    statusCode = exceptionHandler.getStatusCode();
                    target = exceptionHandler.getPage();
                    loggingDetail = exceptionHandler.getLoggingDetail();
                    logger = exceptionHandler.getLogger();
                    break block0;
                }
            }
            if (statusCode > 0) {
                rundata.getResponse().setStatus(statusCode);
                helper.setStatusCode(statusCode);
            }
            helper.logError(logger, loggingDetail);
            if (target == null) {
                target = this.defaultPage;
            }
            rundata.setTarget(target);
        }
        pipelineContext.invokeNext();
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<HandleExceptionValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "defaultPage", "defaultLogging", "defaultLoggerName", "helperName");
            SpringExtUtil.addConstructorArg(builder, true, HttpServletRequest.class);
            List<Object> exceptionHandlers = SpringExtUtil.createManagedList(element, parserContext);
            for (Element onExceptionElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("on-exception")))) {
                exceptionHandlers.add(this.doParseOnException(onExceptionElement, parserContext, builder));
            }
            builder.addPropertyValue("exceptionHandlers", exceptionHandlers);
        }

        private Object doParseOnException(Element onExceptionElement, ParserContext parserContext, BeanDefinitionBuilder builder) {
            BeanDefinitionBuilder onExceptionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExceptionHandler.class);
            onExceptionBuilder.addConstructorArgValue((Object)onExceptionElement.getAttribute("type"));
            if (onExceptionElement.hasAttribute("statusCode")) {
                onExceptionBuilder.addConstructorArgValue((Object)onExceptionElement.getAttribute("statusCode"));
            } else {
                onExceptionBuilder.addConstructorArgValue((Object)"-1");
            }
            onExceptionBuilder.addConstructorArgValue((Object)onExceptionElement.getAttribute("page"));
            onExceptionBuilder.addConstructorArgValue((Object)StringUtil.trimToNull(onExceptionElement.getAttribute("logging")));
            onExceptionBuilder.addConstructorArgValue((Object)onExceptionElement.getAttribute("loggerName"));
            return onExceptionBuilder.getBeanDefinition();
        }
    }

    public static class ExceptionHandler {
        private final Class<? extends Throwable> exceptionType;
        private final int statusCode;
        private final String page;
        private ErrorHandlerHelper.LoggingDetail loggingDetail;
        private Logger logger;

        public ExceptionHandler(Class<? extends Throwable> exceptionType, int statusCode, String page, ErrorHandlerHelper.LoggingDetail loggingDetail, String loggerName) {
            this.exceptionType = Assert.assertNotNull(exceptionType, "no exception type", new Object[0]);
            this.statusCode = statusCode <= 0 ? -1 : statusCode;
            this.page = StringUtil.trimToNull(page);
            this.loggingDetail = loggingDetail;
            loggerName = StringUtil.trimToNull(loggerName);
            if (loggerName != null) {
                this.logger = LoggerFactory.getLogger((String)loggerName);
            }
        }

        private void init(ErrorHandlerHelper.LoggingDetail defaultLoggingDetail, Logger defaultLogger) {
            if (this.logger == null) {
                this.logger = defaultLogger;
            }
            if (this.loggingDetail == null) {
                this.loggingDetail = defaultLoggingDetail;
            }
        }

        public Class<? extends Throwable> getExceptionType() {
            return this.exceptionType;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getPage() {
            return this.page;
        }

        public ErrorHandlerHelper.LoggingDetail getLoggingDetail() {
            return this.loggingDetail;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("on ").append(this.exceptionType.getName());
            if (this.page != null) {
                buf.append(", go to page ").append(this.page);
            }
            if (this.statusCode > 0) {
                buf.append(", with status code ").append(this.statusCode);
            }
            buf.append(", with ").append((Object)this.loggingDetail).append(" logging");
            return buf.toString();
        }
    }
}

