/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.ContributionType;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.VersionableSchemas;
import com.alibaba.citrus.springext.impl.ConfigurationPointSettings;
import com.alibaba.citrus.springext.impl.ContributionImpl;
import com.alibaba.citrus.springext.impl.ContributionKey;
import com.alibaba.citrus.springext.impl.SchemaImpl;
import com.alibaba.citrus.springext.impl.VersionableSchemasImpl;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.parser.DefaultElementDefinitionParser;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

public class ConfigurationPointImpl
extends NamespaceHandlerSupport
implements ConfigurationPoint,
NamespaceHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPoint.class);
    private final ConfigurationPoints cps;
    private final ConfigurationPointSettings settings;
    private final String name;
    private final String namespaceUri;
    private final String defaultElementName;
    private final String preferredNsPrefix;
    private final String contributionLocationPrefix;
    private final Map<ContributionKey, Contribution> contributions;
    private VersionableSchemas schemas;
    private boolean initialized;

    ConfigurationPointImpl(ConfigurationPoints cps, ConfigurationPointSettings settings, String name, String namespaceUri, String defaultElementName, String preferredNsPrefix) {
        this.cps = cps;
        this.settings = settings;
        this.name = Assert.assertNotNull(name, "name", new Object[0]);
        this.namespaceUri = Assert.assertNotNull(namespaceUri, "namespaceUri", new Object[0]);
        this.defaultElementName = StringUtil.trimToNull(defaultElementName);
        this.preferredNsPrefix = StringUtil.trimToNull(preferredNsPrefix);
        this.contributionLocationPrefix = settings.baseLocation + name.replace('/', '-');
        this.contributions = CollectionUtil.createTreeMap();
    }

    @Override
    public ConfigurationPoints getConfigurationPoints() {
        return this.cps;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public String getDefaultElementName() {
        return this.defaultElementName;
    }

    @Override
    public String getPreferredNsPrefix() {
        return this.preferredNsPrefix;
    }

    @Override
    public NamespaceHandler getNamespaceHandler() {
        return this;
    }

    @Override
    public Contribution getContribution(String name, ContributionType type) {
        return this.contributions.get(new ContributionKey(name, type));
    }

    @Override
    public Collection<Contribution> getContributions() {
        return this.contributions.values();
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (ContributionType type : ContributionType.values()) {
            this.loadContributions(type);
        }
        String defaultName = this.getDefaultElementName();
        if (defaultName != null) {
            this.registerBeanDefinitionParser(defaultName, (BeanDefinitionParser)new DefaultElementDefinitionParser());
        }
    }

    private void loadContributions(ContributionType contribType) {
        Properties mappings;
        String contribLocation = this.contributionLocationPrefix + contribType.getContributionsLocationSuffix();
        log.trace("Trying to load contributions at {}", (Object)contribLocation);
        try {
            mappings = PropertiesLoaderUtils.loadAllProperties((String)contribLocation, (ClassLoader)this.settings.classLoader);
        }
        catch (IOException e) {
            throw new ConfigurationPointException("Unable to load Contributions from " + contribLocation, e);
        }
        TreeMap<String, String> sortedMappings = CollectionUtil.createTreeMap();
        for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
            String contribName = StringUtil.trimToNull((String)entry.getKey());
            String contribClassName = StringUtil.trimToNull((String)entry.getValue());
            if (this.getDefaultElementName() != null && ObjectUtil.isEquals(contribName, this.getDefaultElementName())) {
                throw new FatalBeanException("Contribution has a same name as the default element name for configuration point: contributionType=" + (Object)((Object)contribType) + ", contribuitionClass=" + contribClassName + ", contributionName=" + contribName + ", configurationPoint=" + this.getName() + ", namespaceUri=" + this.getNamespaceUri());
            }
            sortedMappings.put(contribName, contribClassName);
            ContributionImpl contrib = new ContributionImpl(this, this.settings, contribType, contribName, contribClassName);
            Contribution existContrib = this.contributions.get(contrib.getKey());
            if (existContrib != null) {
                throw new ConfigurationPointException("Duplicated contributions from locations: " + contribLocation + "\n" + "     " + existContrib + "\n and " + contrib);
            }
            this.register(contrib);
            this.contributions.put(contrib.getKey(), contrib);
        }
        if (log.isDebugEnabled() && !sortedMappings.isEmpty()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Loaded contributions at %s", contribLocation);
            buf.appendMap(sortedMappings);
            log.debug(buf.toString());
        }
    }

    private void register(Contribution contrib) {
        Object obj;
        try {
            obj = this.instantiateContributionImplementation(contrib);
        }
        catch (FatalBeanException e) {
            log.warn("Skipped registration of {} due to the error: {}", (Object)contrib.getDescription(), (Object)e);
            return;
        }
        if (obj instanceof ContributionAware) {
            ((ContributionAware)obj).setContribution(contrib);
        }
        switch (contrib.getType()) {
            case BEAN_DEFINITION_PARSER: {
                this.registerBeanDefinitionParser(contrib.getName(), (BeanDefinitionParser)obj);
                break;
            }
            case BEAN_DEFINITION_DECORATOR: {
                this.registerBeanDefinitionDecorator(contrib.getName(), (BeanDefinitionDecorator)obj);
                break;
            }
            case BEAN_DEFINITION_DECORATOR_FOR_ATTRIBUTE: {
                this.registerBeanDefinitionDecoratorForAttribute(contrib.getName(), (BeanDefinitionDecorator)obj);
                break;
            }
            default: {
                Assert.unreachableCode("unknown contributionType: %s", new Object[]{contrib.getType()});
            }
        }
    }

    private Object instantiateContributionImplementation(Contribution contrib) throws FatalBeanException {
        Class implementationClass;
        String implementationClassName = contrib.getImplementationClassName();
        if (implementationClassName == null) {
            throw new FatalBeanException("Contribution class not defined: contributionType=" + (Object)((Object)contrib.getType()) + ", contributionName=" + contrib.getName() + ", configurationPoint=" + contrib.getConfigurationPoint().getName() + ", namespaceUri=" + contrib.getConfigurationPoint().getNamespaceUri());
        }
        try {
            implementationClass = ClassUtils.forName((String)implementationClassName, (ClassLoader)this.settings.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new FatalBeanException("Contribution class not found: contributionType=" + (Object)((Object)contrib.getType()) + ", contribuitionClass=" + implementationClassName + ", contributionName=" + contrib.getName() + ", configurationPoint=" + contrib.getConfigurationPoint().getName() + ", namespaceUri=" + contrib.getConfigurationPoint().getNamespaceUri(), (Throwable)e);
        }
        if (!contrib.getType().getContributionInterface().isAssignableFrom(implementationClass)) {
            throw new FatalBeanException("Contribution class does not implement the " + contrib.getType().getContributionInterface().getSimpleName() + " interface:  contributionType=" + (Object)((Object)contrib.getType()) + ", contribuitionClass=" + implementationClassName + ", contributionName=" + contrib.getName() + ", configurationPoint=" + contrib.getConfigurationPoint().getName() + ", namespaceUri=" + contrib.getConfigurationPoint().getNamespaceUri());
        }
        return BeanUtils.instantiateClass((Class)implementationClass);
    }

    @Override
    public VersionableSchemas getSchemas() {
        if (this.schemas == null) {
            this.init();
            String mainName = this.getName().replace('/', '-');
            Schema mainSchema = this.loadMainSchema(mainName);
            Schema[] versionedSchemas = this.loadVersionedSchemas(mainName);
            this.schemas = new VersionableSchemasImpl(mainSchema, versionedSchemas);
        }
        return this.schemas;
    }

    private Schema loadMainSchema(String mainName) {
        String schemaName = mainName + "." + "xsd";
        ConfigurationPointSchemaSource schemaSource = new ConfigurationPointSchemaSource(this, null);
        return new SchemaImpl(schemaName, null, this.namespaceUri, this.preferredNsPrefix, this.getDescription(), schemaSource);
    }

    private Schema[] loadVersionedSchemas(String mainName) {
        TreeSet<String> allVersions = CollectionUtil.createTreeSet();
        for (Contribution contrib : this.getContributions()) {
            for (String version : contrib.getSchemas().getVersions()) {
                allVersions.add(version);
            }
        }
        Schema[] schemas = new Schema[allVersions.size()];
        int i = 0;
        for (String version : allVersions) {
            String schemaName = mainName + "-" + version + "." + "xsd";
            ConfigurationPointSchemaSource schemaSource = new ConfigurationPointSchemaSource(this, version);
            schemas[i++] = new SchemaImpl(schemaName, version, this.namespaceUri, this.preferredNsPrefix, this.getDescription(), schemaSource);
        }
        return schemas;
    }

    @Override
    public String getDescription() {
        return String.format("ConfigurationPoint[%s]", this.name);
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("ConfigurationPoint[%s=%s, loaded contributions from %s.*]", this.name, this.namespaceUri, this.contributionLocationPrefix);
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        if (!this.contributions.isEmpty()) {
            mb.append("Contributions", this.contributions.values());
        }
        mb.append("Schemas", this.getSchemas()).appendTo(buf);
        return buf.toString();
    }

    private static class ConfigurationPointSchemaSource
    implements InputStreamSource {
        private final ConfigurationPoint configurationPoint;
        private final String version;

        public ConfigurationPointSchemaSource(ConfigurationPoint configurationPoint, String version) {
            this.configurationPoint = configurationPoint;
            this.version = version;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(SchemaUtil.getConfigurationPointSchemaContent(this.configurationPoint, this.version));
        }

        public String toString() {
            return "generated-content";
        }
    }
}

