/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.template.impl;

import com.alibaba.citrus.service.template.impl.TemplateMatcher;
import com.alibaba.citrus.service.template.impl.TemplateSearchingStrategy;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.util.List;
import java.util.Locale;

public class SearchLocalizedTemplatesStrategy
implements TemplateSearchingStrategy {
    @Override
    public Object getKey(String templateName) {
        return this.getCurrentLocale();
    }

    @Override
    public boolean findTemplate(TemplateMatcher matcher) {
        List<String> localizedTemplateNames = LocaleUtil.calculateBundleNames(matcher.getTemplateNameWithoutExtension(), this.getCurrentLocale(), true);
        for (String name : localizedTemplateNames) {
            matcher.setTemplateNameWithoutExtension(name);
            if (!matcher.findTemplate()) continue;
            return true;
        }
        return false;
    }

    private Locale getCurrentLocale() {
        return LocaleUtil.getContext().getLocale();
    }
}

