/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.support;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextException;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractRequestContextWrapper
implements RequestContext {
    private final RequestContext wrappedContext;
    private final ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public AbstractRequestContextWrapper(RequestContext wrappedContext) {
        this.wrappedContext = Assert.assertNotNull(wrappedContext, "wrappedContext", new Object[0]);
        this.servletContext = wrappedContext.getServletContext();
        this.request = wrappedContext.getRequest();
        this.response = wrappedContext.getResponse();
    }

    @Override
    public RequestContext getWrappedRequestContext() {
        return this.wrappedContext;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    protected void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void commit() throws RequestContextException {
    }

    public String toString() {
        return new ToStringBuilder().append(this.thisToString()).start().append(this.getWrappedRequestContext()).end().toString();
    }

    protected String thisToString() {
        return super.toString();
    }
}

