/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.store.cookie.impl;

import com.alibaba.citrus.service.requestcontext.session.store.cookie.impl.CookieStoreImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CookieStoreDefinitionParser
extends AbstractSingleBeanDefinitionParser<CookieStoreImpl>
implements ContributionAware {
    private ConfigurationPoint encodersConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.encodersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/encoders", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.attributesToProperties(element, builder, "maxLength", "maxCount", "checksum");
        DomUtil.ElementSelector cookieSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("cookie"));
        DomUtil.ElementSelector encodersSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("encoders"));
        for (Element subElement : DomUtil.subElements(element)) {
            if (cookieSelector.accept(subElement)) {
                SpringExtUtil.attributesToProperties(subElement, builder, new String[0]);
                continue;
            }
            if (!encodersSelector.accept(subElement)) continue;
            this.parseEncoders(subElement, parserContext, builder);
        }
    }

    private void parseEncoders(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> encoders = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            encoders.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.encodersConfigurationPoint, parserContext, builder));
        }
        builder.addPropertyValue("encoders", encoders);
    }
}

