/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.impl;

import com.alibaba.citrus.service.requestcontext.session.impl.SessionRequestContextFactoryImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SessionRequestContextFactoryDefinitionParser
extends AbstractSingleBeanDefinitionParser<SessionRequestContextFactoryImpl>
implements ContributionAware {
    private ConfigurationPoint generatorsConfigurationPoint;
    private ConfigurationPoint storesConfigurationPoint;
    private ConfigurationPoint sessionModelEncodersConfigurationPoint;
    private ConfigurationPoint sessionInterceptorsConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.generatorsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/idgens", contrib);
        this.storesConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/stores", contrib);
        this.sessionModelEncodersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/model-encoders", contrib);
        this.sessionInterceptorsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/interceptors", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.attributesToProperties(element, "config.", builder, new String[0]);
        DomUtil.ElementSelector idSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("id"));
        DomUtil.ElementSelector storesSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("stores"));
        DomUtil.ElementSelector storeMappingsSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("store-mappings"));
        DomUtil.ElementSelector sessionModelEncodersSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("session-model-encoders"));
        DomUtil.ElementSelector sessionInterceptorsSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("interceptors"));
        for (Element subElement : DomUtil.subElements(element)) {
            if (idSelector.accept(subElement)) {
                this.parseId(subElement, parserContext, builder);
                continue;
            }
            if (storesSelector.accept(subElement)) {
                this.parseStores(subElement, parserContext, builder);
                continue;
            }
            if (storeMappingsSelector.accept(subElement)) {
                this.parseStoreMappings(subElement, parserContext, builder);
                continue;
            }
            if (sessionModelEncodersSelector.accept(subElement)) {
                this.parseSessionModelEncoders(subElement, parserContext, builder);
                continue;
            }
            if (!sessionInterceptorsSelector.accept(subElement)) continue;
            this.parseSessionInterceptors(subElement, parserContext, builder);
        }
    }

    private void parseId(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.attributesToProperties(element, "config.id.", builder, "cookieEnabled", "urlEncodeEnabled");
        DomUtil.ElementSelector cookieSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("cookie"));
        DomUtil.ElementSelector urlEncodeSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("url-encode"));
        boolean hasGenerator = false;
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder generator;
            if (cookieSelector.accept(subElement)) {
                SpringExtUtil.attributesToProperties(subElement, "config.id.cookie.", builder, new String[0]);
                continue;
            }
            if (urlEncodeSelector.accept(subElement)) {
                SpringExtUtil.attributesToProperties(subElement, "config.id.urlEncode.", builder, new String[0]);
                continue;
            }
            if (hasGenerator || (generator = SpringExtUtil.parseConfigurationPointBean(subElement, this.generatorsConfigurationPoint, parserContext, builder)) == null) continue;
            builder.addPropertyValue("config.id.generator", (Object)generator);
            hasGenerator = true;
        }
    }

    private void parseStores(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Map<Object, Object> storeMap = SpringExtUtil.createManagedMap(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder store = SpringExtUtil.parseConfigurationPointBean(subElement, this.storesConfigurationPoint, parserContext, builder);
            storeMap.put(store.getBeanName(), store);
        }
        builder.addPropertyValue("config.stores.stores", storeMap);
    }

    private void parseStoreMappings(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        DomUtil.ElementSelector matchSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("match"));
        DomUtil.ElementSelector matchRegexSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("matchRegex"));
        List<Object> patterns = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            if (matchSelector.accept(subElement)) {
                patterns.add(this.parseMatch(subElement, parserContext, false));
                continue;
            }
            if (!matchRegexSelector.accept(subElement)) continue;
            patterns.add(this.parseMatch(subElement, parserContext, true));
        }
        builder.addPropertyValue("config.storeMappings.patterns", patterns);
    }

    private BeanDefinition parseMatch(Element element, ParserContext parserContext, boolean regex) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SessionRequestContextFactoryImpl.AttributePattern.class);
        String name = StringUtil.trimToNull(element.getAttribute("name"));
        String patternName = StringUtil.trimToNull(element.getAttribute("pattern"));
        String storeName = StringUtil.trimToNull(element.getAttribute("store"));
        if (regex) {
            builder.getRawBeanDefinition().setFactoryMethodName("getRegexPattern");
            builder.addConstructorArgValue((Object)storeName);
            builder.addConstructorArgValue((Object)patternName);
        } else if ("*".equals(name)) {
            builder.getRawBeanDefinition().setFactoryMethodName("getDefaultPattern");
            builder.addConstructorArgValue((Object)storeName);
        } else {
            builder.getRawBeanDefinition().setFactoryMethodName("getExactPattern");
            builder.addConstructorArgValue((Object)storeName);
            builder.addConstructorArgValue((Object)name);
        }
        return builder.getBeanDefinition();
    }

    private void parseSessionModelEncoders(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> encoders = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            encoders.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.sessionModelEncodersConfigurationPoint, parserContext, builder));
        }
        builder.addPropertyValue("config.sessionModelEncoders", encoders);
    }

    private void parseSessionInterceptors(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> interceptors = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            interceptors.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.sessionInterceptorsConfigurationPoint, parserContext, builder));
        }
        builder.addPropertyValue("config.sessionInterceptors", interceptors);
    }
}

