/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.support;

import com.alibaba.citrus.service.pipeline.Valve;
import com.alibaba.citrus.service.pipeline.impl.PipelineImpl;
import com.alibaba.citrus.service.pipeline.impl.condition.JexlCondition;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractValveDefinitionParser<V extends Valve>
extends AbstractSingleBeanDefinitionParser<V>
implements ContributionAware {
    private ConfigurationPoint valvesConfigurationPoint;
    private ConfigurationPoint conditionsConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.valvesConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/pipeline/valves", contrib);
        this.conditionsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/pipeline/conditions", contrib);
    }

    protected final Object parsePipeline(Element element, ParserContext parserContext) {
        return this.parsePipeline(element, null, parserContext);
    }

    protected final Object parsePipeline(Element element, Element labelElement, ParserContext parserContext) {
        return this.parsePipeline(element, labelElement, parserContext, null);
    }

    protected final Object parsePipeline(Element element, Element labelElement, ParserContext parserContext, String refAttribute) {
        String pipelineRef = StringUtil.trimToNull(element.getAttribute(ObjectUtil.defaultIfNull(StringUtil.trimToNull(refAttribute), "pipeline-ref")));
        if (pipelineRef != null) {
            return new RuntimeBeanReference(pipelineRef);
        }
        BeanDefinitionBuilder pipelineBuilder = BeanDefinitionBuilder.genericBeanDefinition(PipelineImpl.class);
        if (labelElement == null) {
            labelElement = element;
        }
        SpringExtUtil.attributesToProperties(labelElement, pipelineBuilder, "label");
        List<Object> valves = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder valve = SpringExtUtil.parseConfigurationPointBean(subElement, this.valvesConfigurationPoint, parserContext, pipelineBuilder);
            if (valve == null) continue;
            valves.add(valve);
        }
        pipelineBuilder.addPropertyValue("valves", valves);
        return pipelineBuilder.getBeanDefinition();
    }

    protected final Object parseCondition(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String jexl = StringUtil.trimToNull(element.getAttribute("test"));
        if (jexl != null) {
            BeanDefinitionBuilder conditionBuilder = BeanDefinitionBuilder.genericBeanDefinition(JexlCondition.class);
            conditionBuilder.addPropertyValue("expression", (Object)jexl);
            return conditionBuilder.getBeanDefinition();
        }
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder condition = SpringExtUtil.parseConfigurationPointBean(subElement, this.conditionsConfigurationPoint, parserContext, builder);
            if (condition == null) continue;
            return condition;
        }
        return null;
    }
}

