/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl;

import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.impl.PipelineImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedProxyBeanDefinitionParser;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PipelineDefinitionParser
extends AbstractNamedProxyBeanDefinitionParser
implements ContributionAware {
    private ConfigurationPoint valvesConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.valvesConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/pipeline/valves", contrib);
    }

    @Override
    protected String getDefaultName() {
        return "pipeline";
    }

    @Override
    protected Class<?> getProxyInterface(Element element) {
        return Pipeline.class;
    }

    @Override
    protected AbstractBeanDefinitionParser getRealObjectParser() {
        return new AbstractSingleBeanDefinitionParser<PipelineImpl>(){

            protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
                SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
                SpringExtUtil.attributesToProperties(element, builder, "label");
                List<Object> valves = SpringExtUtil.createManagedList(element, parserContext);
                for (Element subElement : DomUtil.subElements(element)) {
                    BeanDefinitionHolder valve = SpringExtUtil.parseConfigurationPointBean(subElement, PipelineDefinitionParser.this.valvesConfigurationPoint, parserContext, builder);
                    if (valve == null) continue;
                    valves.add(valve);
                }
                builder.addPropertyValue("valves", valves);
            }
        };
    }
}

