/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.support.AbstractOptionalValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;
import com.alibaba.citrus.service.form.support.CompareOperator;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;

public class StringCompareValidator
extends AbstractOptionalValidator {
    private String fieldName;
    private CompareOperator op;
    private boolean ignoreCase;

    public String getFieldName() {
        return this.fieldName;
    }

    public CompareOperator getOp() {
        return this.op;
    }

    public void setEqualTo(String fieldName) {
        this.setFieldName(CompareOperator.equalTo, fieldName);
    }

    public void setNotEqualTo(String fieldName) {
        this.setFieldName(CompareOperator.notEqualTo, fieldName);
    }

    private void setFieldName(CompareOperator op, String fieldName) {
        this.op = op;
        this.fieldName = StringUtil.trimToNull(fieldName);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void init(FieldConfig fieldConfig) throws Exception {
        super.init(fieldConfig);
        if (this.fieldName == null || this.op == null) {
            throw new IllegalArgumentException("One of the following attributes should be set: " + CollectionUtil.asList(CompareOperator.equalTo, CompareOperator.notEqualTo));
        }
        Assert.assertNotNull(fieldConfig.getGroupConfig().getFieldConfig(this.fieldName), "Field %s not exists", this.fieldName);
    }

    @Override
    protected boolean validate(Validator.Context context, String value) {
        Field fieldToCompare = Assert.assertNotNull(context.getField(this.fieldName), "field not found", new Object[0]);
        String thisValue = value;
        String otherValue = fieldToCompare.getStringValue();
        if (this.ignoreCase) {
            thisValue = StringUtil.toLowerCase(thisValue);
            otherValue = StringUtil.toLowerCase(otherValue);
        }
        return this.getOp().accept(thisValue.compareTo(otherValue));
    }

    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<StringCompareValidator> {
    }
}

