/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.support.AbstractNumberValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;
import com.alibaba.citrus.service.form.support.CompareOperator;
import com.alibaba.citrus.service.form.support.NumberSupport;
import com.alibaba.citrus.util.StringUtil;

public class NumberValidator
extends AbstractNumberValidator {
    private NumberSupport[] operands = new NumberSupport[CompareOperator.values().length];

    public String getEqualTo() {
        return this.getOperandString(CompareOperator.equalTo);
    }

    public void setEqualTo(String value) {
        this.setOperand(CompareOperator.equalTo, value);
    }

    public String getNotEqualTo() {
        return this.getOperandString(CompareOperator.notEqualTo);
    }

    public void setNotEqualTo(String value) {
        this.setOperand(CompareOperator.notEqualTo, value);
    }

    public String getLessThan() {
        return this.getOperandString(CompareOperator.lessThan);
    }

    public void setLessThan(String value) {
        this.setOperand(CompareOperator.lessThan, value);
    }

    public String getGreaterThan() {
        return this.getOperandString(CompareOperator.greaterThan);
    }

    public void setGreaterThan(String value) {
        this.setOperand(CompareOperator.greaterThan, value);
    }

    public String getLessThanOrEqualTo() {
        return this.getOperandString(CompareOperator.lessThanOrEqualTo);
    }

    public void setLessThanOrEqualTo(String value) {
        this.setOperand(CompareOperator.lessThanOrEqualTo, value);
    }

    public String getGreaterThanOrEqualTo() {
        return this.getOperandString(CompareOperator.greaterThanOrEqualTo);
    }

    public void setGreaterThanOrEqualTo(String value) {
        this.setOperand(CompareOperator.greaterThanOrEqualTo, value);
    }

    private String getOperandString(CompareOperator op) {
        NumberSupport n = this.getOperand(op);
        return n == null ? null : n.getStringValue();
    }

    public final NumberSupport getOperand(CompareOperator op) {
        return this.operands[op.ordinal()];
    }

    protected final void setOperand(CompareOperator op, String value) {
        this.operands[op.ordinal()] = new NumberSupport(null, StringUtil.trimToNull(value));
    }

    @Override
    protected void init() throws Exception {
        super.init();
        for (NumberSupport operand : this.operands) {
            if (operand == null) continue;
            operand.setNumberType(this.getNumberType());
            operand.getValue();
        }
    }

    @Override
    protected boolean validate(Validator.Context context, String value) {
        NumberSupport numberValue = new NumberSupport(this.getNumberType(), value);
        boolean valid = true;
        try {
            numberValue.getValue();
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        if (valid) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == null) continue;
                valid &= CompareOperator.values()[i].accept(numberValue.compareTo(this.operands[i]));
            }
        }
        return valid;
    }

    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<NumberValidator> {
    }
}

