/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.expr.jexl;

import com.alibaba.citrus.expr.Expression;
import com.alibaba.citrus.expr.ExpressionContext;
import com.alibaba.citrus.expr.ExpressionFactory;
import com.alibaba.citrus.expr.ExpressionParseException;
import com.alibaba.citrus.expr.jexl.JexlExpression;
import com.alibaba.citrus.expr.support.ExpressionSupport;
import org.apache.commons.jexl2.JexlEngine;

public class JexlExpressionFactory
implements ExpressionFactory {
    private final JexlEngine engine = new JexlEngine();
    private boolean supportContextVariables = true;

    public boolean isSupportContextVariables() {
        return this.supportContextVariables;
    }

    public void setSupportContextVariables(boolean supportContextVariables) {
        this.supportContextVariables = supportContextVariables;
    }

    @Override
    public Expression createExpression(final String expr) throws ExpressionParseException {
        JexlExpression jexlExpression;
        try {
            jexlExpression = new JexlExpression(this.engine.createExpression(expr));
        }
        catch (Exception e) {
            throw new ExpressionParseException(e);
        }
        if (this.isSupportContextVariables() && this.isValidContextVariableName(expr)) {
            return new ExpressionSupport(){

                @Override
                public String getExpressionText() {
                    return expr;
                }

                @Override
                public Object evaluate(ExpressionContext context) {
                    Object value = jexlExpression.evaluate(context);
                    if (value == null) {
                        value = context.get(expr);
                    }
                    return value;
                }
            };
        }
        return jexlExpression;
    }

    protected boolean isValidContextVariableName(String varName) {
        for (int i = 0; i < varName.length(); ++i) {
            char ch = varName.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '[') continue;
            return false;
        }
        return true;
    }
}

