/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl.visitor;

import com.alibaba.citrus.dev.handler.impl.ExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.AbstractFallbackVisitor;
import com.alibaba.citrus.dev.handler.util.BeanDefinitionReverseEngine;
import com.alibaba.citrus.dev.handler.util.Element;
import com.alibaba.citrus.dev.handler.util.ReflectionUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class BeansVisitor
extends AbstractFallbackVisitor<ExplorerHandler.ExplorerVisitor> {
    private final DefaultListableBeanFactory factory;

    public BeansVisitor(RequestHandlerContext context, ExplorerHandler.ExplorerVisitor v) {
        super(context, v);
        this.factory = (DefaultListableBeanFactory)v.getApplicationContext().getBeanFactory();
    }

    public void visitBeanCount() {
        ((PrintWriter)this.out()).print(this.factory.getBeanDefinitionCount());
    }

    public void visitBeans() {
        LinkedList<Element> elements = CollectionUtil.createLinkedList();
        for (String name : this.getSortedBeanNames()) {
            Element beanElement = null;
            try {
                RootBeanDefinition bd = this.getBeanDefinition(name);
                beanElement = new BeanDefinitionReverseEngine((AbstractBeanDefinition)bd, name, this.factory.getAliases(name)).toDom();
            }
            catch (Exception e) {
                beanElement = new Element("bean").setText(ExceptionUtil.getStackTrace(ExceptionUtil.getRootCause(e)));
            }
            if (beanElement == null) continue;
            elements.add(beanElement);
        }
        ((ExplorerHandler.ExplorerVisitor)this.getFallbackVisitor()).getDomComponent().visitTemplate(this.context, elements);
    }

    private RootBeanDefinition getBeanDefinition(String name) throws Exception {
        return (RootBeanDefinition)ReflectionUtil.getAccessibleMethod(this.factory.getClass(), "getMergedLocalBeanDefinition", new Class[]{String.class}).invoke((Object)this.factory, name);
    }

    private String[] getSortedBeanNames() {
        int i;
        String[] names = this.factory.getBeanDefinitionNames();
        Object[] beanNames = new BeanName[names.length];
        for (i = 0; i < names.length; ++i) {
            beanNames[i] = new BeanName();
            ((BeanName)beanNames[i]).beanName = names[i];
            ((BeanName)beanNames[i]).components = StringUtil.split(names[i], ".");
        }
        Arrays.sort(beanNames);
        names = new String[beanNames.length];
        for (i = 0; i < beanNames.length; ++i) {
            names[i] = ((BeanName)beanNames[i]).beanName;
        }
        return names;
    }

    static class BeanName
    implements Comparable<BeanName> {
        String beanName;
        String[] components;

        BeanName() {
        }

        @Override
        public int compareTo(BeanName o) {
            if (this.components.length != o.components.length) {
                return this.components.length - o.components.length;
            }
            for (int i = 0; i < this.components.length; ++i) {
                String comp1 = this.components[i];
                String comp2 = o.components[i];
                if (comp1.equals(comp2)) continue;
                return comp1.compareTo(comp2);
            }
            return 0;
        }
    }
}

