/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Condition;
import co.paralleluniverse.strands.ConditionSynchronizer;
import co.paralleluniverse.strands.Strand;
import sun.misc.Unsafe;

@Instrumented
public class OwnedSynchronizer
extends ConditionSynchronizer
implements Condition {
    private volatile Strand waiter;
    private static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long waiterOffset;

    public OwnedSynchronizer(Object owner) {
        super(owner);
    }

    @Override
    public Object register() {
        Strand currentStrand = Strand.currentStrand();
        OwnedSynchronizer.record("register", "%s register %s", this, currentStrand);
        if (!this.casWaiter(null, currentStrand)) {
            throw new IllegalMonitorStateException("attempt by " + currentStrand + " but owned by " + this.waiter);
        }
        return null;
    }

    @Override
    public void unregister(Object registrationToken) {
        Strand currentStrand = Strand.currentStrand();
        OwnedSynchronizer.record("unregister", "%s unregister %s", this, currentStrand);
        if (!Strand.equals(this.waiter, currentStrand)) {
            throw new IllegalMonitorStateException("attempt by " + Strand.currentStrand() + " but owned by " + this.waiter);
        }
        this.waiter = null;
    }

    @Override
    public void signalAll() {
        this.signal();
    }

    @Override
    public void signal() {
        Strand s = this.waiter;
        OwnedSynchronizer.record("signal", "%s signalling %s", this, s);
        if (s != null) {
            Strand.unpark(s, this.owner);
        }
    }

    private boolean casWaiter(Strand expected, Strand update) {
        return UNSAFE.compareAndSwapObject(this, waiterOffset, expected, update);
    }

    static {
        try {
            waiterOffset = UNSAFE.objectFieldOffset(OwnedSynchronizer.class.getDeclaredField("waiter"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=63, methodEnd=68, suspendableCallSites={66}, suspendableCallSiteNames={"co/paralleluniverse/strands/Strand.yieldAndUnpark(Lco/paralleluniverse/strands/Strand;Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={120})
    public void signalAndWait() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

