/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.schedule.model;

import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.schedule.model.IModel;
import cn.jpush.api.schedule.model.TriggerPayload;
import cn.jpush.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SchedulePayload
implements IModel {
    private static Gson gson = new Gson();
    private String name;
    private Boolean enabled;
    private TriggerPayload trigger;
    private PushPayload push;

    private SchedulePayload(String name, Boolean enabled, TriggerPayload trigger, PushPayload push) {
        this.name = name;
        this.enabled = enabled;
        this.trigger = trigger;
        this.push = push;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (StringUtils.isNotEmpty(this.name)) {
            json.addProperty("name", this.name);
        }
        if (null != this.enabled) {
            json.addProperty("enabled", this.enabled);
        }
        if (null != this.trigger) {
            json.add("trigger", this.trigger.toJSON());
        }
        if (null != this.push) {
            json.add("push", this.push.toJSON());
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String name;
        private Boolean enabled;
        private TriggerPayload trigger;
        private PushPayload push;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setTrigger(TriggerPayload trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder setPush(PushPayload push) {
            this.push = push;
            return this;
        }

        public SchedulePayload build() {
            return new SchedulePayload(this.name, this.enabled, this.trigger, this.push);
        }
    }
}

