/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jiguang.commom.ServiceHelper;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class IosNotification
extends PlatformNotification {
    public static final String NOTIFICATION_IOS = "ios";
    private static final String DEFAULT_SOUND = "";
    private static final String DEFAULT_BADGE = "+1";
    private static final String BADGE = "badge";
    private static final String SOUND = "sound";
    private static final String CONTENT_AVAILABLE = "content-available";
    private static final String CATEGORY = "category";
    private static final String ALERT_VALID_BADGE = "Badge number should be 0~99999, and can be prefixed with + to add, - to minus";
    private final boolean soundDisabled;
    private final boolean badgeDisabled;
    private final String sound;
    private final String badge;
    private final boolean contentAvailable;
    private final String category;

    private IosNotification(Object alert, String sound, String badge, boolean contentAvailable, boolean soundDisabled, boolean badgeDisabled, String category, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras);
        this.sound = sound;
        this.badge = badge;
        this.contentAvailable = contentAvailable;
        this.soundDisabled = soundDisabled;
        this.badgeDisabled = badgeDisabled;
        this.category = category;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static IosNotification alert(String alert) {
        return IosNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_IOS;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (!this.badgeDisabled) {
            if (null != this.badge) {
                json.add(BADGE, (JsonElement)new JsonPrimitive(this.badge));
            } else {
                json.add(BADGE, (JsonElement)new JsonPrimitive(DEFAULT_BADGE));
            }
        }
        if (!this.soundDisabled) {
            if (null != this.sound) {
                json.add(SOUND, (JsonElement)new JsonPrimitive(this.sound));
            } else {
                json.add(SOUND, (JsonElement)new JsonPrimitive(DEFAULT_SOUND));
            }
        }
        if (this.contentAvailable) {
            json.add(CONTENT_AVAILABLE, (JsonElement)new JsonPrimitive((Number)1));
        }
        if (null != this.category) {
            json.add(CATEGORY, (JsonElement)new JsonPrimitive(this.category));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<IosNotification, Builder> {
        private String sound;
        private String badge;
        private boolean contentAvailable = false;
        private boolean soundDisabled = false;
        private boolean badgeDisabled = false;
        private String category;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder disableSound() {
            this.soundDisabled = true;
            return this;
        }

        public Builder incrBadge(int badge) {
            if (!ServiceHelper.isValidIntBadge((int)Math.abs(badge))) {
                PlatformNotification.LOG.warn(IosNotification.ALERT_VALID_BADGE);
                return this;
            }
            this.badge = badge >= 0 ? "+" + badge : IosNotification.DEFAULT_SOUND + badge;
            return this;
        }

        public Builder setBadge(int badge) {
            if (!ServiceHelper.isValidIntBadge((int)badge)) {
                PlatformNotification.LOG.warn(IosNotification.ALERT_VALID_BADGE);
                return this;
            }
            this.badge = IosNotification.DEFAULT_SOUND + badge;
            return this;
        }

        public Builder autoBadge() {
            return this.incrBadge(1);
        }

        public Builder disableBadge() {
            this.badgeDisabled = true;
            return this;
        }

        public Builder setContentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        @Override
        public Builder setAlert(Object alert) {
            this.alert = alert;
            return this;
        }

        @Override
        public IosNotification build() {
            return new IosNotification(this.alert, this.sound, this.badge, this.contentAvailable, this.soundDisabled, this.badgeDisabled, this.category, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

