/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.PushModel;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlatformNotification
implements PushModel {
    public static final String ALERT = "alert";
    private static final String EXTRAS = "extras";
    protected static final Logger LOG = LoggerFactory.getLogger(PlatformNotification.class);
    private String alert;
    private final ImmutableMap<String, String> extras;
    private final ImmutableMap<String, Number> numberExtras;
    private final ImmutableMap<String, Boolean> booleanExtras;

    public PlatformNotification(String alert, ImmutableMap<String, String> extras, ImmutableMap<String, Number> numberExtras, ImmutableMap<String, Boolean> booleanExtras) {
        this.alert = alert;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
    }

    @Override
    public JsonElement toJSON() {
        Object value;
        JsonObject json = new JsonObject();
        if (null != this.alert) {
            json.add(ALERT, (JsonElement)new JsonPrimitive(this.alert));
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            value = null;
            for (String key : this.extras.keySet()) {
                value = (String)this.extras.get((Object)key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((String)value));
            }
        }
        if (null != this.numberExtras) {
            value = null;
            for (String key : this.numberExtras.keySet()) {
                value = (Number)this.numberExtras.get((Object)key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Number)value));
            }
        }
        if (null != this.booleanExtras) {
            value = null;
            for (String key : this.booleanExtras.keySet()) {
                value = (Boolean)this.booleanExtras.get((Object)key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Boolean)value));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        return json;
    }

    protected String getAlert() {
        return this.alert;
    }

    protected void setAlert(String alert) {
        this.alert = alert;
    }

    protected abstract String getPlatform();

    protected static abstract class Builder<T> {
        protected String alert;
        protected ImmutableMap.Builder<String, String> extrasBuilder;
        protected ImmutableMap.Builder<String, Number> numberExtrasBuilder;
        protected ImmutableMap.Builder<String, Boolean> booleanExtrasBuilder;

        protected Builder() {
        }

        public abstract Builder<T> setAlert(String var1);

        public abstract Builder<T> addExtra(String var1, String var2);

        public abstract Builder<T> addExtra(String var1, Number var2);

        public abstract Builder<T> addExtra(String var1, Boolean var2);

        public abstract T build();
    }
}

