/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.examples;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.APIConnectionException;
import cn.jpush.api.common.APIRequestException;
import cn.jpush.api.common.TimeUnit;
import cn.jpush.api.report.MessagesResult;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.report.UsersResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsExample {
    protected static final Logger LOG = LoggerFactory.getLogger(ReportsExample.class);
    private static final String appKey = "dd1066407b044738b6479275";
    private static final String masterSecret = "2b38ce69b1de2a7fa95706ea";

    public static void main(String[] args) {
        ReportsExample.testGetReport();
        ReportsExample.testGetMessages();
        ReportsExample.testGetUsers();
    }

    public static void testGetReport() {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey);
        try {
            ReceivedsResult result = jpushClient.getReportReceiveds("1942377665");
            LOG.debug("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.info("HTTP Status: " + e.getStatus());
            LOG.info("Error Code: " + e.getErrorCode());
            LOG.info("Error Message: " + e.getErrorMessage());
        }
    }

    public static void testGetUsers() {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey);
        try {
            UsersResult result = jpushClient.getReportUsers(TimeUnit.DAY, "2014-06-10", 3);
            LOG.debug("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.info("HTTP Status: " + e.getStatus());
            LOG.info("Error Code: " + e.getErrorCode());
            LOG.info("Error Message: " + e.getErrorMessage());
        }
    }

    public static void testGetMessages() {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey);
        try {
            MessagesResult result = jpushClient.getReportMessages("269978303");
            LOG.debug("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.info("HTTP Status: " + e.getStatus());
            LOG.info("Error Code: " + e.getErrorCode());
            LOG.info("Error Message: " + e.getErrorMessage());
        }
    }
}

