/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.yun.push.transform;

import com.baidu.yun.core.annotation.CollectionRestrict;
import com.baidu.yun.core.annotation.HttpParamKeyName;
import com.baidu.yun.core.annotation.HttpPathKeyName;
import com.baidu.yun.core.annotation.R;
import com.baidu.yun.core.annotation.RangeRestrict;
import com.baidu.yun.core.annotation.RegexRestrict;
import com.baidu.yun.core.utility.StringUtility;
import com.baidu.yun.push.exception.PushClientException;
import com.baidu.yun.push.model.PushRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class PushRestRequestChecker {
    public boolean validate(PushRequest request) throws PushClientException {
        Field[] childField = request.getClass().getDeclaredFields();
        Field[] superFileds = request.getClass().getSuperclass().getDeclaredFields();
        LinkedList<Field> fieldList = new LinkedList<Field>();
        fieldList.addAll(Arrays.asList(childField));
        fieldList.addAll(Arrays.asList(superFileds));
        for (Field field : fieldList.toArray(new Field[0])) {
            try {
                CollectionRestrict rcollection;
                RangeRestrict range;
                Annotation annotation;
                Object obj;
                field.setAccessible(true);
                if (field.isAnnotationPresent(HttpPathKeyName.class) && (obj = field.get(request)) == null && (annotation = field.getAnnotation(HttpPathKeyName.class)).param() == R.REQUIRE) {
                    throw new PushClientException(field.getName() + " is null, default require");
                }
                if (!field.isAnnotationPresent(HttpParamKeyName.class)) continue;
                obj = field.get(request);
                if (obj == null) {
                    annotation = field.getAnnotation(HttpParamKeyName.class);
                    if (annotation.param() != R.REQUIRE) continue;
                    throw new PushClientException(field.getName() + " is null, default require");
                }
                annotation = field.getAnnotation(HttpParamKeyName.class);
                Class<?> zlass = field.getType();
                if (zlass.equals(Long.class) || "long".equalsIgnoreCase(zlass.getName())) {
                    RangeRestrict range2;
                    if (obj == null) {
                        if (annotation.param() != R.REQUIRE) continue;
                        throw new PushClientException(field.getName() + " haven't been set, default require");
                    }
                    long ele = (Long)obj;
                    if (!field.isAnnotationPresent(RangeRestrict.class) || ele >= (range2 = field.getAnnotation(RangeRestrict.class)).minLength() && ele <= range2.maxLength()) continue;
                    throw new PushClientException(field.getName() + " value isn't in range [" + range2.minLength() + ", " + range2.maxLength() + "].");
                }
                if (zlass.equals(Integer.class) || "int".equalsIgnoreCase(zlass.getName())) {
                    if (obj == null) {
                        if (annotation.param() != R.REQUIRE) continue;
                        throw new PushClientException(field.getName() + " haven't been set, default require");
                    }
                    int ele = (Integer)obj;
                    if (!field.isAnnotationPresent(RangeRestrict.class) || (long)ele >= (range = field.getAnnotation(RangeRestrict.class)).minLength() && (long)ele <= range.maxLength()) continue;
                    throw new PushClientException(field.getName() + " value isn't in range [" + range.minLength() + ", " + range.maxLength() + "].");
                }
                if (zlass.equals(String.class)) {
                    RegexRestrict regex;
                    if (StringUtility.isNull((String)obj)) {
                        throw new PushClientException(field.getName() + " is Zero Length String");
                    }
                    String sobj = (String)obj;
                    if (field.isAnnotationPresent(RangeRestrict.class)) {
                        range = field.getAnnotation(RangeRestrict.class);
                        if ((long)sobj.length() < range.minLength() || (long)sobj.length() > range.maxLength()) {
                            throw new PushClientException(field.getName() + " length isn't in range [" + range.minLength() + ", " + range.maxLength() + "].");
                        }
                    }
                    if (!field.isAnnotationPresent(RegexRestrict.class) || Pattern.matches((regex = field.getAnnotation(RegexRestrict.class)).regex(), sobj)) continue;
                    throw new PushClientException(field.getName() + " doesn't meet the regular expression " + regex.regex());
                }
                if (zlass.equals(Date.class) || zlass.isEnum()) continue;
                if (zlass.equals(List.class)) {
                    List list = (List)obj;
                    if (list.size() == 0) {
                        throw new PushClientException(field.getName() + " size is zero.");
                    }
                    if (field.isAnnotationPresent(CollectionRestrict.class)) {
                        rcollection = field.getAnnotation(CollectionRestrict.class);
                        if (list.size() < rcollection.minLength() || list.size() > rcollection.maxLength()) {
                            throw new PushClientException(field.getName() + " size isn't in range [" + rcollection.minLength() + ", " + rcollection.maxLength() + "].");
                        }
                    }
                    for (Object o : list) {
                        RangeRestrict range3;
                        RangeRestrict range4;
                        if (o instanceof String) {
                            RegexRestrict regex;
                            String ele = (String)o;
                            if (field.isAnnotationPresent(RangeRestrict.class)) {
                                range4 = field.getAnnotation(RangeRestrict.class);
                                if ((long)ele.length() < range4.minLength() || (long)ele.length() > range4.maxLength()) {
                                    throw new PushClientException(field.getName() + " length isn't in range [" + range4.minLength() + ", " + range4.maxLength() + "].");
                                }
                            }
                            if (!field.isAnnotationPresent(RegexRestrict.class) || Pattern.matches((regex = field.getAnnotation(RegexRestrict.class)).regex(), ele)) continue;
                            throw new PushClientException(field.getName() + " doesn't meet the regular expression " + regex.regex());
                        }
                        if (o instanceof Integer) {
                            int ele = (Integer)o;
                            if (!field.isAnnotationPresent(RangeRestrict.class) || (long)ele >= (range4 = field.getAnnotation(RangeRestrict.class)).minLength() && (long)ele <= range4.maxLength()) continue;
                            throw new PushClientException(field.getName() + " value isn't in range [" + range4.minLength() + ", " + range4.maxLength() + "].");
                        }
                        if (!(o instanceof Long)) continue;
                        long ele = (Long)o;
                        if (!field.isAnnotationPresent(RangeRestrict.class) || ele >= (range3 = field.getAnnotation(RangeRestrict.class)).minLength() && ele <= range3.maxLength()) continue;
                        throw new PushClientException(field.getName() + " value isn't in range [" + range3.minLength() + ", " + range3.maxLength() + "].");
                    }
                    continue;
                }
                if (zlass.equals(Set.class)) {
                    Set set = (Set)obj;
                    if (set.size() == 0) {
                        throw new PushClientException(field.getName() + " size is zero.");
                    }
                    if (field.isAnnotationPresent(CollectionRestrict.class)) {
                        rcollection = field.getAnnotation(CollectionRestrict.class);
                        if (set.size() < rcollection.minLength() || set.size() > rcollection.maxLength()) {
                            throw new PushClientException(field.getName() + " size isn't in range [" + rcollection.minLength() + ", " + rcollection.maxLength() + "].");
                        }
                    }
                    for (String ele : set) {
                        RegexRestrict regex;
                        if (field.isAnnotationPresent(RangeRestrict.class)) {
                            RangeRestrict range5 = field.getAnnotation(RangeRestrict.class);
                            if ((long)ele.length() < range5.minLength() || (long)ele.length() > range5.maxLength()) {
                                throw new PushClientException(field.getName() + " length isn't in range [" + range5.minLength() + ", " + range5.maxLength() + "].");
                            }
                        }
                        if (!field.isAnnotationPresent(RegexRestrict.class) || Pattern.matches((regex = field.getAnnotation(RegexRestrict.class)).regex(), ele)) continue;
                        throw new PushClientException(field.getName() + " doesn't meet the regular expression " + regex.regex());
                    }
                    continue;
                }
                throw new PushClientException("no " + field.getName() + " field type");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

