/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro.core.handler;

import cn.dreampie.shiro.core.handler.AbstractAuthzHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.subject.Subject;

public class RoleAuthzHandler
extends AbstractAuthzHandler {
    private final Annotation annotation;

    public RoleAuthzHandler(Annotation annotation) {
        this.annotation = annotation;
    }

    public RoleAuthzHandler(String jdbcRole) {
        this.annotation = null;
    }

    public void assertAuthorized() throws AuthorizationException {
        Subject subject = this.getSubject();
        if (!(this.annotation instanceof RequiresRoles)) {
            return;
        }
        RequiresRoles rrAnnotation = (RequiresRoles)this.annotation;
        String[] roles = rrAnnotation.value();
        if (roles.length == 1) {
            subject.checkRole(roles[0]);
            return;
        }
        if (Logical.AND.equals((Object)rrAnnotation.logical())) {
            subject.checkRoles(Arrays.asList(roles));
            return;
        }
        if (Logical.OR.equals((Object)rrAnnotation.logical())) {
            boolean hasAtLeastOneRole = false;
            for (String role : roles) {
                if (!subject.hasRole(role)) continue;
                hasAtLeastOneRole = true;
            }
            if (!hasAtLeastOneRole) {
                subject.checkRole(roles[0]);
            }
        }
    }
}

