/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.shiro.core;

import cn.dreampie.shiro.core.JdbcAuthzService;
import cn.dreampie.shiro.core.handler.AuthzHandler;
import cn.dreampie.shiro.core.handler.JdbcPermissionAuthzHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiroKit {
    private static final Logger log = LoggerFactory.getLogger(ShiroKit.class);
    private static ConcurrentMap<String, AuthzHandler> authzMaps = null;
    private static Map<String, AuthzHandler> authzJdbcMaps = null;
    public static AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static JdbcAuthzService jdbcAuthzService;
    private static boolean and;

    private ShiroKit() {
    }

    static void init(JdbcAuthzService jdbcAuthzSrc, ConcurrentMap<String, AuthzHandler> amaps, boolean isAnd) {
        jdbcAuthzService = jdbcAuthzSrc;
        authzMaps = amaps;
        and = isAnd;
        ShiroKit.loadJdbcAuthz();
    }

    static AuthzHandler getAuthzHandler(String actionKey) {
        return (AuthzHandler)authzMaps.get(actionKey);
    }

    static List<AuthzHandler> getJdbcAuthzHandler(HttpServletRequest request) {
        ArrayList<AuthzHandler> result = new ArrayList<AuthzHandler>();
        String url = WebUtils.getPathWithinApplication((HttpServletRequest)request);
        for (String key : authzJdbcMaps.keySet()) {
            if (!antPathMatcher.match(key, url)) continue;
            result.add(authzJdbcMaps.get(key));
            if (and) continue;
            break;
        }
        return result;
    }

    static List<AuthzHandler> getAuthzHandler(HttpServletRequest request, String actionKey) {
        List<AuthzHandler> result = ShiroKit.getJdbcAuthzHandler(request);
        AuthzHandler ah = ShiroKit.getAuthzHandler(actionKey);
        if (ah != null) {
            result.add(ah);
        }
        return result;
    }

    public static boolean hasJdbcAuthz(String url) {
        return authzJdbcMaps.containsKey(url);
    }

    public static void addJdbcAuthz(String url, String value) {
        authzJdbcMaps.put(url, new JdbcPermissionAuthzHandler(value));
    }

    public static void removeJdbcAuthz(String url) {
        authzJdbcMaps.remove(url);
    }

    public static void loadJdbcAuthz() {
        ShiroKit.loadJdbcAuthz(false);
    }

    public static void loadJdbcAuthz(boolean clear) {
        if (jdbcAuthzService != null) {
            if (clear) {
                authzJdbcMaps.clear();
            }
            authzJdbcMaps = jdbcAuthzService.getJdbcAuthz();
        } else {
            log.error("authzJdbcService not found!can't load database url premission");
        }
    }

    static {
        and = false;
    }
}

