/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.validation;

import club.zhcs.common.Result;
import java.util.ArrayList;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.util.NutMap;
import org.springframework.http.HttpStatus;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ValidationExceptionHandler {
    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result handle(MethodArgumentNotValidException exception) {
        final ArrayList errors = new ArrayList();
        Lang.each((Object)exception.getBindingResult().getAllErrors(), (Each)new Each<ObjectError>(){

            public void invoke(int index, ObjectError error, int length) throws ExitLoop, ContinueLoop, LoopException {
                errors.add(NutMap.NEW().addv("msg", (Object)error.getDefaultMessage()).addv("obj", (Object)error.getObjectName()).addv("arguments", (Object)error.getArguments()).addv("code", (Object)error.getCode()).addv("codes", (Object)error.getCodes()));
            }
        });
        return Result.fail((Object[])new Object[]{errors});
    }

    @ResponseBody
    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result handle(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            final ArrayList errors = new ArrayList();
            Lang.each((Object)((ConstraintViolationException)exception).getConstraintViolations(), (Each)new Each<ConstraintViolation>(){

                public void invoke(int index, ConstraintViolation error, int length) throws ExitLoop, ContinueLoop, LoopException {
                    errors.add(NutMap.NEW().addv("msg", (Object)error.getMessage()).addv("obj", (Object)error.getConstraintDescriptor()).addv("arguments", (Object)error.getExecutableParameters()));
                }
            });
            return Result.fail((Object[])new Object[]{errors});
        }
        return Result.fail((Object[])new Object[]{"\u53c2\u6570\u4e0d\u6b63\u786e"});
    }
}

