/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

abstract class OutputAccessor {
    private static final ThreadLocal<ByteBufferOutputAccessor> accessors = new ThreadLocal<ByteBufferOutputAccessor>(){

        @Override
        protected ByteBufferOutputAccessor initialValue() {
            return new ByteBufferOutputAccessor();
        }
    };
    private static final ThreadLocal<ByteBufferOutputStream> streams = new ThreadLocal<ByteBufferOutputStream>(){

        @Override
        protected ByteBufferOutputStream initialValue() {
            return new ByteBufferOutputStream(null);
        }
    };

    OutputAccessor() {
    }

    public abstract void write(int var1);

    public abstract void write(byte[] var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public static OutputAccessor from(OutputStream outputStream) {
        return new OutputStreamAccessor(outputStream);
    }

    public static OutputAccessor from(ByteBuffer byteBuffer) {
        ByteBufferOutputAccessor accessor = accessors.get();
        accessor.byteBuffer = byteBuffer;
        return accessor;
    }

    public static OutputStream pooledStream() {
        return streams.get();
    }

    public static OutputStream asStream(ByteBuffer byteBuffer) {
        ByteBufferOutputStream accessor = streams.get();
        accessor.byteBuffer = byteBuffer;
        return accessor;
    }

    static class OutputStreamAccessor
    extends OutputAccessor {
        private final OutputStream delegate;

        public OutputStreamAccessor(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.delegate.write(b, off, len);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void write(byte[] b) {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void write(int b) {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class ByteBufferOutputStream
    extends OutputStream {
        private ByteBuffer byteBuffer;

        public ByteBufferOutputStream(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.byteBuffer.put(b, off, len);
        }

        @Override
        public void write(byte[] b) {
            this.byteBuffer.put(b);
        }

        @Override
        public void write(int b) {
            this.byteBuffer.put((byte)b);
        }
    }

    static class ByteBufferOutputAccessor
    extends OutputAccessor {
        private ByteBuffer byteBuffer;

        ByteBufferOutputAccessor() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.byteBuffer.put(b, off, len);
        }

        @Override
        public void write(byte[] b) {
            this.byteBuffer.put(b);
        }

        @Override
        public void write(int b) {
            this.byteBuffer.put((byte)b);
        }
    }
}

