/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.tuple.predicate;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.signature.InputValidator;
import uk.gov.gchq.koryphe.signature.Signature;
import uk.gov.gchq.koryphe.tuple.predicate.TupleAdaptedPredicate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
public class IntegerTupleAdaptedPredicate
extends TupleAdaptedPredicate<Integer, Object>
implements InputValidator {
    public IntegerTupleAdaptedPredicate() {
    }

    public IntegerTupleAdaptedPredicate(Predicate predicate, Integer ... selection) {
        super(predicate, selection);
    }

    @Override
    public ValidationResult isInputValid(Class<?> ... arguments) {
        if (null == this.getPredicate()) {
            return new ValidationResult();
        }
        Integer[] selection = (Integer[])this.getSelection();
        if (null == selection) {
            return Signature.getInputSignature(this.getPredicate()).assignable(new Class[0]);
        }
        Class[] selectedArgs = new Class[selection.length];
        int i = 0;
        for (Integer selectionIndex : selection) {
            if (selectionIndex >= arguments.length) {
                ValidationResult result = new ValidationResult();
                result.addError("Incorrect selection of arguments for nested predicate " + this.getPredicate().getClass().getName() + ". Selection requires " + (Collections.max(Arrays.asList(selection)) + 1) + " arguments, however only " + arguments.length + " provided.");
                return result;
            }
            selectedArgs[i] = arguments[selectionIndex];
            ++i;
        }
        return Signature.getInputSignature(this.getPredicate()).assignable(selectedArgs);
    }
}

