/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.tuple;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.function.BiFunction;
import uk.gov.gchq.koryphe.tuple.Tuple;

public class TupleOutputAdapter<R, FO>
implements BiFunction<Tuple<R>, FO, Tuple<R>> {
    private R[] projection;

    public TupleOutputAdapter() {
        this.projection = new Object[0];
    }

    public TupleOutputAdapter(R[] projection) {
        this.setProjection(projection);
    }

    @Override
    public Tuple<R> apply(Tuple<R> state, FO output) {
        if (null == this.projection) {
            throw new IllegalArgumentException("Projection is required");
        }
        if (null != state) {
            if (1 == this.projection.length) {
                state.put(this.projection[0], output);
            } else {
                int i = 0;
                for (Object obj : (Iterable)output) {
                    state.put(this.projection[i++], obj);
                }
            }
        }
        return state;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Cloning the array would be expensive - we will have to reply on users not modifying the array")
    public void setProjection(R[] projection) {
        this.projection = null == projection ? new Object[0] : projection;
    }

    public R[] getProjection() {
        return Arrays.copyOf(this.projection, this.projection.length);
    }
}

