/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.tuple;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.function.Function;
import uk.gov.gchq.koryphe.tuple.ReferenceArrayTuple;
import uk.gov.gchq.koryphe.tuple.Tuple;

public class TupleInputAdapter<R, FI>
implements Function<Tuple<R>, FI> {
    private R[] selection;

    public TupleInputAdapter() {
        this.selection = new Object[0];
    }

    public TupleInputAdapter(R[] selection) {
        this.setSelection(selection);
    }

    @Override
    public FI apply(Tuple<R> input) {
        if (null == this.selection) {
            throw new IllegalArgumentException("Selection is required");
        }
        if (null != input && 1 == this.selection.length) {
            return (FI)input.get(this.selection[0]);
        }
        return (FI)new ReferenceArrayTuple<R>(input, this.selection);
    }

    public R[] getSelection() {
        return Arrays.copyOf(this.selection, this.selection.length);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Cloning the array would be expensive - we will have to reply on users not modifying the array")
    public void setSelection(R[] selection) {
        this.selection = null == selection ? new Object[0] : selection;
    }
}

