/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.tuple;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.tuple.ArrayTuple;
import uk.gov.gchq.koryphe.tuple.Tuple;
import uk.gov.gchq.koryphe.tuple.n.Tuple5;

public class ReferenceArrayTuple<R>
extends Tuple5 {
    private final R[] fields;
    private final Tuple<R> tuple;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Cloning the array would be expensive - we will have to reply on users not modifying the array")
    public ReferenceArrayTuple(Tuple<R> tuple, R[] fields) {
        this.tuple = tuple;
        this.fields = fields;
    }

    @Override
    public Object get(Integer index) {
        if (null != this.tuple && index < this.fields.length) {
            return this.tuple.get(this.fields[index]);
        }
        return null;
    }

    @Override
    public void put(Integer index, Object value) {
        if (null != this.tuple && index < this.fields.length) {
            R field = this.fields[index];
            this.tuple.put(field, value);
        }
    }

    @Override
    public Iterable<Object> values() {
        ArrayTuple selected = new ArrayTuple(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            selected.put(i, this.get(i));
        }
        return selected;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values().iterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceArrayTuple concat = (ReferenceArrayTuple)obj;
        return new EqualsBuilder().append((Object[])this.fields, (Object[])concat.fields).append(this.tuple, concat.tuple).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(13, 31).append((Object[])this.fields).append(this.tuple).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("fields", (Object[])this.fields).append("tuple", this.tuple).build();
    }
}

