/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.tuple;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.tuple.Tuple;

public class ArrayTuple
implements Tuple<Integer> {
    private final Object[] values;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This class is designed to simply wrap an object array.")
    public ArrayTuple(Object ... values) {
        this.values = values;
    }

    public ArrayTuple(int size) {
        this.values = new Object[size];
    }

    @Override
    public Object get(Integer index) {
        if (index < this.values.length) {
            return this.values[index];
        }
        return null;
    }

    @Override
    public void put(Integer index, Object value) {
        if (index < this.values.length) {
            this.values[index.intValue()] = value;
        }
    }

    @Override
    public Iterable<Object> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values().iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayTuple concat = (ArrayTuple)obj;
        return new EqualsBuilder().append(this.values, concat.values).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 31).append(this.values).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("values", this.values).build();
    }
}

