/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.signature;

import java.util.Arrays;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.signature.InputValidator;
import uk.gov.gchq.koryphe.signature.OutputValidator;
import uk.gov.gchq.koryphe.signature.Signature;
import uk.gov.gchq.koryphe.signature.SingletonSignature;
import uk.gov.gchq.koryphe.tuple.n.Tuple1;

public class TupleSignature
extends Signature {
    private final Object input;
    private final Integer numClasses;
    private final Class[] classes;
    private final SingletonSignature[] types;
    private final boolean isInput;

    TupleSignature(Object input, Class tupleClazz, Class[] classes, boolean isInput) {
        this.input = input;
        this.classes = classes;
        this.isInput = isInput;
        this.numClasses = 1 == classes.length && !Tuple1.class.isAssignableFrom(tupleClazz) ? null : Integer.valueOf(classes.length);
        this.types = new SingletonSignature[classes.length];
        int i = 0;
        for (Class clazz : classes) {
            this.types[i++] = new SingletonSignature(input, clazz, isInput);
        }
    }

    @Override
    public ValidationResult assignable(Class<?> ... arguments) {
        ValidationResult result;
        block9: {
            if (this.isInput) {
                if (this.input instanceof InputValidator) {
                    return ((InputValidator)this.input).isInputValid(arguments);
                }
            } else if (this.input instanceof OutputValidator) {
                return ((OutputValidator)this.input).isOutputValid(arguments);
            }
            result = new ValidationResult();
            if (null == this.types) break block9;
            if (null != this.numClasses && this.types.length != arguments.length) {
                result.addError("Incompatible number of types. " + this.input.getClass() + ": " + Arrays.toString(this.types) + ", arguments: " + Arrays.toString(arguments));
                return result;
            }
            if (null == this.numClasses) {
                for (Class<?> type : arguments) {
                    result.add(this.types[0].assignable(type));
                }
            } else {
                int i = 0;
                for (Class<?> type : arguments) {
                    result.add(this.types[i].assignable(type));
                    ++i;
                }
            }
        }
        return result;
    }

    @Override
    public Integer getNumClasses() {
        return this.numClasses;
    }

    @Override
    public Class[] getClasses() {
        return Arrays.copyOf(this.classes, this.classes.length);
    }
}

