/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.signature;

import java.util.Arrays;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.signature.InputValidator;
import uk.gov.gchq.koryphe.signature.OutputValidator;
import uk.gov.gchq.koryphe.signature.Signature;

public class SingletonSignature
extends Signature {
    private final Object input;
    private final boolean isInput;
    private Class<?> type;

    SingletonSignature(Object input, Class type, boolean isInput) {
        this.input = input;
        this.type = type;
        this.isInput = isInput;
    }

    @Override
    public ValidationResult assignable(Class<?> ... arguments) {
        if (this.isInput) {
            if (this.input instanceof InputValidator) {
                return ((InputValidator)this.input).isInputValid(arguments);
            }
        } else if (this.input instanceof OutputValidator) {
            return ((OutputValidator)this.input).isOutputValid(arguments);
        }
        ValidationResult result = new ValidationResult();
        if (this.type == null) {
            result.addError("Type could not be extracted from function " + this.input.getClass().getName());
            return result;
        }
        if (Signature.UnknownGenericType.class.equals(this.type)) {
            return result;
        }
        if (arguments.length != 1 || null == arguments[0]) {
            result.addError("Incompatible number of types. " + this.input.getClass().getName() + ": [" + this.type + "], arguments: " + Arrays.toString(arguments));
            return result;
        }
        boolean isAssignable = this.type.isAssignableFrom(arguments[0]);
        if (!isAssignable) {
            result.addError("Incompatible types. " + this.input.getClass().getName() + ": [" + this.type + "], arguments: " + Arrays.toString(arguments));
        }
        return result;
    }

    @Override
    public Class[] getClasses() {
        return new Class[]{this.type};
    }

    @Override
    public Integer getNumClasses() {
        return Signature.UnknownGenericType.class.equals(this.type) ? null : Integer.valueOf(1);
    }
}

