/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.signature;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.reflect.TypeUtils;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.signature.SingletonSignature;
import uk.gov.gchq.koryphe.signature.TupleSignature;
import uk.gov.gchq.koryphe.tuple.Tuple;

public abstract class Signature {
    public abstract ValidationResult assignable(Class<?> ... var1);

    public abstract Class[] getClasses();

    public abstract Integer getNumClasses();

    public static Signature getInputSignature(Predicate function) {
        return Signature.createSignatureFromTypeVariable(function, Predicate.class, 0, true);
    }

    public static Signature getInputSignature(Function function) {
        return Signature.createSignatureFromTypeVariable(function, Function.class, 0, true);
    }

    public static <F extends BiFunction<I, O, O>, I, O> Signature getInputSignature(F function) {
        return Signature.createSignatureFromTypeVariable(function, BiFunction.class, 0, true);
    }

    public static Signature getOutputSignature(Function function) {
        return Signature.createSignatureFromTypeVariable(function, Function.class, 1, false);
    }

    public static <F extends BiFunction<I, O, O>, I, O> Signature getOutputSignature(F function) {
        return Signature.createSignatureFromTypeVariable(function, BiFunction.class, 2, false);
    }

    private static Signature createSignatureFromTypeVariable(Object input, Class functionClass, int typeVariableIndex, boolean isInput) {
        TypeVariable tv = functionClass.getTypeParameters()[typeVariableIndex];
        Map typeArgs = TypeUtils.getTypeArguments(input.getClass(), (Class)functionClass);
        Type type = (Type)typeArgs.get(tv);
        return Signature.createSignature(input, type, typeArgs, isInput);
    }

    private static Signature createSignature(Object input, Type type, Map<TypeVariable<?>, Type> typeArgs, boolean isInput) {
        Class clazz = Signature.getTypeClass(type, typeArgs);
        if (Tuple.class.isAssignableFrom(clazz)) {
            TypeVariable<Class<T>>[] tupleTypes = Signature.getTypeClass(type, typeArgs).getTypeParameters();
            Map classTypeArgs = TypeUtils.getTypeArguments((Type)type, (Class)clazz);
            Collection types = TypeUtils.getTypeArguments((Type)type, (Class)clazz).values();
            Class[] classes = new Class[types.size()];
            int i = 0;
            for (TypeVariable tupleType : tupleTypes) {
                classes[i++] = Signature.getTypeClass((Type)classTypeArgs.get(tupleType), typeArgs);
            }
            return new TupleSignature(input, clazz, classes, isInput);
        }
        return new SingletonSignature(input, clazz, isInput);
    }

    protected static Class getTypeClass(Type type, Map<TypeVariable<?>, Type> typeArgs) {
        Type t;
        Type rawType = type;
        if (type instanceof ParameterizedType) {
            rawType = ((ParameterizedType)type).getRawType();
        }
        if (rawType instanceof Class) {
            return (Class)rawType;
        }
        if (rawType instanceof TypeVariable && null != (t = typeArgs.get(rawType))) {
            return Signature.getTypeClass(t, typeArgs);
        }
        return UnknownGenericType.class;
    }

    public static class UnknownGenericType {
    }
}

