/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.predicate;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Predicate;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.composite.Composite;
import uk.gov.gchq.koryphe.signature.InputValidator;
import uk.gov.gchq.koryphe.signature.Signature;
import uk.gov.gchq.koryphe.tuple.Tuple;
import uk.gov.gchq.koryphe.tuple.predicate.TupleAdaptedPredicate;

public class PredicateComposite<I, C extends Predicate<I>>
extends Composite<C>
implements Predicate<I>,
InputValidator {
    public PredicateComposite() {
    }

    public PredicateComposite(List<C> predicates) {
        super(predicates);
    }

    @Override
    @JsonProperty(value="predicates")
    public List<C> getComponents() {
        return super.getComponents();
    }

    @Override
    public boolean test(I input) {
        for (Predicate predicate : this.components) {
            try {
                if (predicate.test(input)) continue;
                return false;
            }
            catch (ClassCastException e) {
                if (predicate instanceof TupleAdaptedPredicate && !(input instanceof Tuple)) {
                    if (((TupleAdaptedPredicate)predicate).getPredicate().test(input)) continue;
                    return false;
                }
                throw e;
            }
        }
        return true;
    }

    @Override
    public ValidationResult isInputValid(Class<?> ... arguments) {
        if (null == this.components) {
            return new ValidationResult();
        }
        ValidationResult result = new ValidationResult();
        for (Predicate component : this.components) {
            result.add(Signature.getInputSignature(component).assignable(arguments));
        }
        return result;
    }
}

