/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.impl.predicate;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.predicate.PredicateComposite;
import uk.gov.gchq.koryphe.tuple.Tuple;
import uk.gov.gchq.koryphe.tuple.predicate.IntegerTupleAdaptedPredicate;
import uk.gov.gchq.koryphe.tuple.predicate.TupleAdaptedPredicate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
public class Or<I>
extends PredicateComposite<I, Predicate<I>> {
    public Or() {
    }

    public Or(Predicate<?> ... predicates) {
        this(Lists.newArrayList((Object[])predicates));
    }

    public Or(List<Predicate> predicates) {
        super(predicates);
    }

    @Override
    public boolean test(I input) {
        for (Predicate predicate : this.components) {
            try {
                if (!predicate.test(input)) continue;
                return true;
            }
            catch (ClassCastException e) {
                if (predicate instanceof TupleAdaptedPredicate && !(input instanceof Tuple)) {
                    if (!((TupleAdaptedPredicate)predicate).getPredicate().test(input)) continue;
                    return true;
                }
                throw e;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this).toString();
    }

    public static final class SelectedBuilder<I> {
        private final Or<I> or;
        private final IntegerTupleAdaptedPredicate current;

        private SelectedBuilder(Or<I> or, IntegerTupleAdaptedPredicate current) {
            this.or = or;
            this.current = current;
        }

        public Builder<I> execute(Predicate function) {
            this.current.setPredicate(function);
            this.or.getComponents().add(this.current);
            return new Builder(this.or);
        }
    }

    public static class Builder<I> {
        private final Or<I> or;

        public Builder() {
            this(new Or());
        }

        private Builder(Or<I> or) {
            this.or = or;
        }

        public SelectedBuilder<I> select(Integer ... selection) {
            IntegerTupleAdaptedPredicate current = new IntegerTupleAdaptedPredicate();
            current.setSelection(selection);
            return new SelectedBuilder(this.or, current);
        }

        public Or<I> build() {
            return this.or;
        }
    }
}

