/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.impl.predicate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.predicate.KoryphePredicate;

public class MultiRegex
extends KoryphePredicate<String> {
    private Pattern[] patterns;

    public MultiRegex() {
        this(null);
    }

    public MultiRegex(Pattern[] patterns) {
        this.setPatterns(patterns);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonProperty(value="value")
    public Pattern[] getPatterns() {
        return Arrays.copyOf(this.patterns, this.patterns.length);
    }

    public void setPatterns(Pattern[] patterns) {
        this.patterns = null != patterns ? Arrays.copyOf(patterns, patterns.length) : new Pattern[0];
    }

    @Override
    public boolean test(String input) {
        if (null == input || input.getClass() != String.class) {
            return false;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MultiRegex that = (MultiRegex)obj;
        return new EqualsBuilder().append((Object[])this.patternsToStrings(this.patterns), (Object[])this.patternsToStrings(that.patterns)).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object[])this.patternsToStrings(this.patterns)).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("patterns", (Object[])this.patterns).toString();
    }

    private String[] patternsToStrings(Pattern[] patterns) {
        ArrayList<String> strings = new ArrayList<String>(patterns.length);
        for (Pattern pattern : patterns) {
            strings.add(pattern.toString());
        }
        return strings.toArray(new String[0]);
    }
}

