/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.impl.predicate;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.predicate.KoryphePredicate;
import uk.gov.gchq.koryphe.signature.InputValidator;

public class IsShorterThan
extends KoryphePredicate<Object>
implements InputValidator {
    private int maxLength;
    private boolean orEqualTo;

    public IsShorterThan() {
    }

    public IsShorterThan(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isOrEqualTo() {
        return this.orEqualTo;
    }

    public void setOrEqualTo(boolean orEqualTo) {
        this.orEqualTo = orEqualTo;
    }

    @Override
    public boolean test(Object input) {
        if (null == input) {
            return true;
        }
        if (this.orEqualTo) {
            return this.getLength(input) <= this.maxLength;
        }
        return this.getLength(input) < this.maxLength;
    }

    private int getLength(Object value) {
        int length;
        if (value instanceof String) {
            length = ((String)value).length();
        } else if (value instanceof Object[]) {
            length = ((Object[])value).length;
        } else if (value instanceof Collection) {
            length = ((Collection)value).size();
        } else if (value instanceof Map) {
            length = ((Map)value).size();
        } else {
            throw new IllegalArgumentException("Could not determine the size of the provided value");
        }
        return length;
    }

    @Override
    public ValidationResult isInputValid(Class<?> ... arguments) {
        ValidationResult result = new ValidationResult();
        if (null == arguments || 1 != arguments.length || null == arguments[0]) {
            result.addError("Incorrect number of arguments for " + this.getClass().getName() + ". 1 argument is required.");
            return result;
        }
        if (!(String.class.isAssignableFrom(arguments[0]) || Object[].class.isAssignableFrom(arguments[0]) || Collection.class.isAssignableFrom(arguments[0]) || Map.class.isAssignableFrom(arguments[0]))) {
            result.addError("Input class " + arguments[0].getName() + " must be one of the following: " + String.class.getName() + ", " + Object[].class.getName() + ", " + Collection.class.getName() + ", " + Map.class.getName());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        IsShorterThan that = (IsShorterThan)obj;
        return new EqualsBuilder().append(this.maxLength, that.maxLength).append(this.orEqualTo, that.orEqualTo).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.maxLength).append(this.orEqualTo).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("maxLength", this.maxLength).append("orEqualTo", this.orEqualTo).toString();
    }
}

