/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.impl.predicate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.predicate.KoryphePredicate;
import uk.gov.gchq.koryphe.signature.InputValidator;

public class IsMoreThan
extends KoryphePredicate<Comparable>
implements InputValidator {
    private Comparable controlValue;
    private boolean orEqualTo;

    public IsMoreThan() {
    }

    public IsMoreThan(Comparable<?> controlValue) {
        this(controlValue, false);
    }

    public IsMoreThan(Comparable controlValue, boolean orEqualTo) {
        this.controlValue = controlValue;
        this.orEqualTo = orEqualTo;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonProperty(value="value")
    public Comparable getControlValue() {
        return this.controlValue;
    }

    public void setControlValue(Comparable controlValue) {
        this.controlValue = controlValue;
    }

    public boolean getOrEqualTo() {
        return this.orEqualTo;
    }

    public void setOrEqualTo(boolean orEqualTo) {
        this.orEqualTo = orEqualTo;
    }

    @Override
    public boolean test(Comparable input) {
        if (null == input || !this.controlValue.getClass().isAssignableFrom(input.getClass())) {
            return false;
        }
        int compareVal = this.controlValue.compareTo(input);
        if (this.orEqualTo) {
            return compareVal <= 0;
        }
        return compareVal < 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        IsMoreThan that = (IsMoreThan)obj;
        return new EqualsBuilder().append(this.orEqualTo, that.orEqualTo).append((Object)this.controlValue, (Object)that.controlValue).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.controlValue).append(this.orEqualTo).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("controlValue", (Object)this.controlValue).append("orEqualTo", this.orEqualTo).toString();
    }

    @Override
    public ValidationResult isInputValid(Class<?> ... arguments) {
        ValidationResult result = new ValidationResult();
        if (null == this.controlValue) {
            result.addError("Control value has not been set");
            return result;
        }
        if (null == arguments || 1 != arguments.length || null == arguments[0]) {
            result.addError("Incorrect number of arguments for " + this.getClass().getName() + ". 1 argument is required.");
            return result;
        }
        if (!this.controlValue.getClass().isAssignableFrom(arguments[0])) {
            result.addError("Control value class " + this.controlValue.getClass().getName() + " is not compatible with the input type: " + arguments[0]);
        }
        return result;
    }
}

