/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.impl.predicate;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import uk.gov.gchq.koryphe.predicate.KoryphePredicate;

public class AgeOff
extends KoryphePredicate<Long> {
    public static final long HOURS_TO_MILLISECONDS = 3600000L;
    public static final long DAYS_TO_MILLISECONDS = 86400000L;
    public static final long AGE_OFF_TIME_DEFAULT = 31536000000L;
    private long ageOffTime = 31536000000L;

    public AgeOff() {
    }

    public AgeOff(long ageOffTime) {
        this.ageOffTime = ageOffTime;
    }

    @Override
    public boolean test(Long input) {
        return null != input && System.currentTimeMillis() - input < this.ageOffTime;
    }

    public long getAgeOffTime() {
        return this.ageOffTime;
    }

    public void setAgeOffTime(long ageOffTime) {
        this.ageOffTime = ageOffTime;
    }

    public void setAgeOffDays(int ageOfDays) {
        this.setAgeOffTime(86400000L * (long)ageOfDays);
    }

    public void setAgeOffHours(long ageOfHours) {
        this.setAgeOffTime(3600000L * ageOfHours);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AgeOff otherPredicate = (AgeOff)obj;
        return new EqualsBuilder().append(this.ageOffTime, otherPredicate.ageOffTime).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.ageOffTime).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ageOffTime", this.ageOffTime).toString();
    }
}

