/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe.impl.binaryoperator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.impl.binaryoperator.NumericAggregateFunction;

public class Sum
extends NumericAggregateFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationResult.class);

    @Override
    protected Integer aggregateInt(Integer a, Integer b) {
        return a + b;
    }

    @Override
    protected Long aggregateLong(Long a, Long b) {
        return a + b;
    }

    @Override
    protected Double aggregateDouble(Double a, Double b) {
        return a + b;
    }

    @Override
    protected Float aggregateFloat(Float a, Float b) {
        return Float.valueOf(a.floatValue() + b.floatValue());
    }

    @Override
    protected Short aggregateShort(Short a, Short b) {
        int sum = a + b;
        if (sum > Short.MAX_VALUE) {
            LOGGER.warn("Sum of " + a + " and " + b + " exceeded the max short value. The max short value (32767) was used instead.");
            return (short)Short.MAX_VALUE;
        }
        return (short)sum;
    }
}

