/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.koryphe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationResult.class);
    private boolean isValid = true;
    private Set<String> errors;

    public ValidationResult() {
    }

    public ValidationResult(String errorMsg) {
        this.addError(errorMsg);
    }

    public void addError(String msg) {
        this.isValid = false;
        if (null == this.errors) {
            this.errors = new LinkedHashSet<String>();
        }
        this.errors.add(msg);
    }

    public void add(ValidationResult validationResult) {
        this.add(validationResult, null);
    }

    public void add(ValidationResult validationResult, String errorMessage) {
        if (!validationResult.isValid()) {
            this.isValid = false;
            if (null == this.errors) {
                this.errors = new LinkedHashSet<String>(validationResult.getErrors());
            } else {
                this.errors.addAll(validationResult.getErrors());
            }
            if (null != errorMessage) {
                this.errors.add(errorMessage);
            }
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Set<String> getErrors() {
        if (null == this.errors) {
            return Collections.emptySet();
        }
        return this.errors;
    }

    public void logErrors() {
        this.getErrors().forEach(arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public void logWarns() {
        this.getErrors().forEach(arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    public void logInfo() {
        this.getErrors().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    public void logDebug() {
        this.getErrors().forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
    }

    public void logTrace() {
        this.getErrors().forEach(arg_0 -> ((Logger)LOGGER).trace(arg_0));
    }

    @JsonIgnore
    public String getErrorString() {
        return "Validation errors: " + System.lineSeparator() + StringUtils.join(this.getErrors(), (String)System.lineSeparator());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("isInputValid", this.isValid).append("errors", this.errors).build();
    }
}

