/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.stream;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import uk.gov.gchq.gaffer.commonutil.iterable.LimitedInMemorySortedIterable;

public final class GafferCollectors {
    private GafferCollectors() {
    }

    public static <T> Collector<T, ?, Set<T>> toLinkedHashSet() {
        return new GafferCollectorImpl<Object, Set, Set>(LinkedHashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, set -> set);
    }

    public static <T> Collector<T, LimitedInMemorySortedIterable<T>, LimitedInMemorySortedIterable<T>> toLimitedInMemorySortedIterable(Comparator<T> comparator, Integer limit, boolean deduplicate) {
        return new GafferCollectorImpl(() -> new LimitedInMemorySortedIterable(comparator, limit, deduplicate), LimitedInMemorySortedIterable::add, (left, right) -> {
            left.addAll(right);
            return left;
        });
    }

    static class GafferCollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;

        GafferCollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
        }

        GafferCollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner) {
            this(supplier, accumulator, combiner, i -> i);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return new HashSet<Collector.Characteristics>();
        }
    }
}

