/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.Authorisations;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ElementVisibility;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.exception.VisibilityParseException;

public class VisibilityEvaluator {
    private Authorisations auths;

    public VisibilityEvaluator(Authorisations auths) {
        this.auths = auths;
    }

    public boolean evaluate(ElementVisibility visibility) throws VisibilityParseException {
        return this.evaluate(visibility.getExpression(), visibility.getParseTree());
    }

    private boolean evaluate(byte[] expression, ElementVisibility.Node root) throws VisibilityParseException {
        if (expression.length == 0) {
            return true;
        }
        switch (root.type) {
            case TERM: {
                return this.auths.contains(root.getTerm(expression));
            }
            case AND: {
                if (root.children == null || root.children.size() < 2) {
                    throw new VisibilityParseException("AND has less than 2 children", expression, root.start);
                }
                for (ElementVisibility.Node child : root.children) {
                    if (this.evaluate(expression, child)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                if (root.children == null || root.children.size() < 2) {
                    throw new VisibilityParseException("OR has less than 2 children", expression, root.start);
                }
                for (ElementVisibility.Node child : root.children) {
                    if (!this.evaluate(expression, child)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new VisibilityParseException("No such node type", expression, root.start);
    }

    public static byte[] escape(byte[] auth, boolean quote) {
        int escapeCount = 0;
        byte[] newAuth = auth;
        for (int i = 0; i < auth.length; ++i) {
            if (auth[i] != 34 && auth[i] != 92) continue;
            ++escapeCount;
        }
        if (escapeCount > 0 || quote) {
            byte[] escapedAuth = new byte[auth.length + escapeCount + (quote ? 2 : 0)];
            int index = quote ? 1 : 0;
            for (int i = 0; i < auth.length; ++i) {
                if (auth[i] == 34 || auth[i] == 92) {
                    escapedAuth[index++] = 92;
                }
                escapedAuth[index++] = auth[i];
            }
            if (quote) {
                escapedAuth[0] = 34;
                escapedAuth[escapedAuth.length - 1] = 34;
            }
            newAuth = escapedAuth;
        }
        return newAuth;
    }
}

