/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbExternals
extends SvnWcDbShared {
    public static void addExternalDir(SVNWCDb db, File localAbspath, File wriPath, SVNURL reposRootUrl, String reposUuid, File recordAncestorAbspath, File recordedReposRelPath, long recordedPegRevision, long recordedRevision, SVNSkel workItems) throws SVNException {
        if (wriPath == null) {
            wriPath = SVNFileUtil.getParentFile(localAbspath);
        }
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(wriPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        File localRelpath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root.getAbsPath().getAbsolutePath(), localAbspath.getAbsolutePath()));
        Object externalInfo = Structure.obtain(StructureFields.ExternalNodeInfo.class);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.revision, -1L);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.changedRevision, -1L);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposId, -1L);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedRevision, -1L);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedPegRevision, -1L);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.Dir);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.presence, (Object)ISVNWCDb.SVNWCDbStatus.Normal);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposRootUrl, reposRootUrl);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposUuid, reposUuid);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordAncestorRelPath, SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root.getAbsPath().getAbsolutePath(), recordAncestorAbspath.getAbsolutePath())));
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedReposRelPath, recordedReposRelPath);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedPegRevision, recordedPegRevision);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedRevision, recordedRevision);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.workItems, workItems);
        SvnWcDbExternals.begingWriteTransaction(root);
        try {
            try {
                SvnWcDbExternals.insertExternalNode(root, localRelpath, externalInfo);
            }
            catch (SVNException e) {
                SvnWcDbExternals.rollbackTransaction(root);
                throw e;
            }
            Object var18_14 = null;
        }
        catch (Throwable throwable) {
            Object var18_15 = null;
            SvnWcDbExternals.commitTransaction(root);
            ((Structure)externalInfo).release();
            throw throwable;
        }
        SvnWcDbExternals.commitTransaction(root);
        ((Structure)externalInfo).release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertExternalNode(SVNWCDbRoot root, File localRelpath, Structure<StructureFields.ExternalNodeInfo> info) throws SVNException {
        long reposId;
        block10: {
            reposId = info.lng(StructureFields.ExternalNodeInfo.reposId);
            if (reposId == -1L) {
                reposId = root.getDb().createReposId(root.getSDb(), (SVNURL)info.get(StructureFields.ExternalNodeInfo.reposRootUrl), info.text(StructureFields.ExternalNodeInfo.reposUuid));
            }
            try {
                ISVNWCDb.WCDbBaseInfo baseInfo = root.getDb().getBaseInfo(root, localRelpath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
                boolean updateRoot = baseInfo.updateRoot;
                ISVNWCDb.SVNWCDbStatus status = baseInfo.status;
                if (status == ISVNWCDb.SVNWCDbStatus.Normal && !updateRoot) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block10;
                throw e;
            }
        }
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.ExternalNodeInfo.kind));
        if (kind == ISVNWCDb.SVNWCDbKind.File || kind == ISVNWCDb.SVNWCDbKind.Symlink) {
            SVNWCDb.InsertBase insertBase = root.getDb().new SVNWCDb.InsertBase();
            insertBase.localRelpath = localRelpath;
            insertBase.status = ISVNWCDb.SVNWCDbStatus.Normal;
            insertBase.kind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.ExternalNodeInfo.kind));
            insertBase.reposId = reposId;
            insertBase.reposRelpath = (File)info.get(StructureFields.ExternalNodeInfo.reposRelPath);
            insertBase.revision = info.lng(StructureFields.ExternalNodeInfo.revision);
            insertBase.props = (SVNProperties)info.get(StructureFields.ExternalNodeInfo.properties);
            insertBase.changedRev = info.lng(StructureFields.ExternalNodeInfo.changedRevision);
            insertBase.changedDate = (SVNDate)info.get(StructureFields.ExternalNodeInfo.changedDate);
            insertBase.changedAuthor = info.text(StructureFields.ExternalNodeInfo.changedAuthor);
            insertBase.davCache = (SVNProperties)info.get(StructureFields.ExternalNodeInfo.davCache);
            insertBase.checksum = (SvnChecksum)info.get(StructureFields.ExternalNodeInfo.checksum);
            insertBase.target = (File)info.get(StructureFields.ExternalNodeInfo.target);
            insertBase.conflict = (SVNSkel)info.get(StructureFields.ExternalNodeInfo.conflict);
            insertBase.updateActualProps = info.is(StructureFields.ExternalNodeInfo.updateActualProperties);
            insertBase.actualProps = (SVNProperties)info.get(StructureFields.ExternalNodeInfo.newActualProperties);
            insertBase.keepRecordedInfo = info.is(StructureFields.ExternalNodeInfo.keepRecordedInfo);
            insertBase.workItems = (SVNSkel)info.get(StructureFields.ExternalNodeInfo.workItems);
            insertBase.fileExternal = true;
            insertBase.iprops = (Map)info.get(StructureFields.ExternalNodeInfo.iprops);
            insertBase.wcId = root.getWcId();
            insertBase.wcRoot = root;
            try {
                insertBase.transaction(root.getSDb());
            }
            catch (SqlJetException e) {
                SvnWcDbExternals.sqliteError(e);
            }
        } else {
            root.getDb().addWorkQueue(root.getAbsPath(), (SVNSkel)info.get(StructureFields.ExternalNodeInfo.workItems));
        }
        InsertExternalStatement stmt = new InsertExternalStatement(root.getSDb());
        try {
            stmt.bindf("issttsisii", root.getWcId(), localRelpath, SVNFileUtil.getFileDir(localRelpath), SvnWcDbStatementUtil.getPresenceText((ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.ExternalNodeInfo.presence))), SvnWcDbStatementUtil.getKindText((ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.ExternalNodeInfo.kind))), info.get(StructureFields.ExternalNodeInfo.recordAncestorRelPath), reposId, info.get(StructureFields.ExternalNodeInfo.recordedReposRelPath), info.lng(StructureFields.ExternalNodeInfo.recordedPegRevision), info.lng(StructureFields.ExternalNodeInfo.recordedRevision));
            stmt.done();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            stmt.reset();
            throw throwable;
        }
        stmt.reset();
    }

    public static void removeExternal(SVNWCContext context, File wriAbsPath, File localAbsPath) throws SVNException {
        Structure<StructureFields.ExternalNodeInfo> info = SvnWcDbExternals.readExternal(context, localAbsPath, wriAbsPath, StructureFields.ExternalNodeInfo.presence, StructureFields.ExternalNodeInfo.kind);
        SvnWcDbExternals.removeExternalNode(context, localAbsPath, wriAbsPath, null);
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.ExternalNodeInfo.kind));
        info.release();
        if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
            SVNWCContext.CheckWCRootInfo wcRootInfo = context.checkWCRoot(localAbsPath, false);
            if (wcRootInfo != null && wcRootInfo.wcRoot) {
                context.removeFromRevisionControl(localAbsPath, true, false);
            }
        } else {
            block6: {
                try {
                    ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot);
                    if (baseInfo != null && !baseInfo.updateRoot) {
                        return;
                    }
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block6;
                    throw e;
                }
            }
            context.getDb().removeBase(localAbsPath);
            SVNFileUtil.deleteFile(localAbsPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeExternalNode(SVNWCContext context, File localAbsPath, File wriAbsPath, SVNSkel workItems) throws SVNException {
        if (wriAbsPath == null) {
            wriAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        }
        SVNWCDb.DirParsedInfo dirInfo = ((SVNWCDb)context.getDb()).obtainWcRoot(wriAbsPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        File localRelpath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root.getAbsPath().getAbsolutePath(), localAbsPath.getAbsolutePath()));
        SvnWcDbExternals.begingWriteTransaction(root);
        SVNSqlJetDeleteStatement deleteExternal = null;
        try {
            block7: {
                try {
                    deleteExternal = new SVNSqlJetDeleteStatement(root.getSDb(), SVNWCDbSchema.EXTERNALS);
                    try {
                        deleteExternal.bindf("is", root.getWcId(), localRelpath);
                        deleteExternal.done();
                        Object var9_8 = null;
                        deleteExternal.reset();
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        deleteExternal.reset();
                        throw throwable;
                    }
                    if (workItems == null) break block7;
                    root.getDb().addWorkQueue(root.getAbsPath(), workItems);
                }
                catch (SVNException e) {
                    SvnWcDbExternals.rollbackTransaction(root);
                    Object var11_13 = null;
                    SvnWcDbExternals.commitTransaction(root);
                    return;
                }
            }
            Object var11_12 = null;
            SvnWcDbExternals.commitTransaction(root);
            return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            SvnWcDbExternals.commitTransaction(root);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure<StructureFields.ExternalNodeInfo> readExternal(SVNWCContext context, File localAbsPath, File wriAbsPath, StructureFields.ExternalNodeInfo ... fields) throws SVNException {
        SVNSqlJetSelectStatement selectExternalInfo;
        block7: {
            Object x;
            if (wriAbsPath == null) {
                wriAbsPath = SVNFileUtil.getParentFile(localAbsPath);
            }
            SVNWCDb.DirParsedInfo dirInfo = ((SVNWCDb)context.getDb()).obtainWcRoot(wriAbsPath);
            SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
            File localRelpath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root.getAbsPath().getAbsolutePath(), localAbsPath.getAbsolutePath()));
            selectExternalInfo = new SVNSqlJetSelectStatement(root.getSDb(), SVNWCDbSchema.EXTERNALS);
            try {
                selectExternalInfo.bindf("is", root.getWcId(), localRelpath);
                if (!selectExternalInfo.next()) break block7;
                Object info = Structure.obtain(StructureFields.ExternalNodeInfo.class, fields);
                if (((Structure)info).hasField(StructureFields.ExternalNodeInfo.presence)) {
                    ((Structure)info).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.presence, (Object)SvnWcDbStatementUtil.getColumnPresence(selectExternalInfo, SVNWCDbSchema.EXTERNALS__Fields.presence));
                }
                if (((Structure)info).hasField(StructureFields.ExternalNodeInfo.kind)) {
                    ((Structure)info).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.kind, (Object)SvnWcDbStatementUtil.getColumnKind(selectExternalInfo, SVNWCDbSchema.EXTERNALS__Fields.kind));
                }
                if (((Structure)info).hasField(StructureFields.ExternalNodeInfo.definingAbsPath)) {
                    ((Structure)info).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.definingAbsPath, SVNFileUtil.createFilePath(root.getAbsPath(), selectExternalInfo.getColumnString(SVNWCDbSchema.EXTERNALS__Fields.def_local_relpath)));
                }
                x = info;
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                SvnWcDbStatementUtil.reset(selectExternalInfo);
                throw throwable;
            }
            SvnWcDbStatementUtil.reset(selectExternalInfo);
            return x;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' is not an external.", (Object)localAbsPath);
        SVNErrorManager.error(err, SVNLogType.WC);
        Object var11_12 = null;
        SvnWcDbStatementUtil.reset(selectExternalInfo);
        return null;
    }

    public static void addExternalFile(SVNWCContext context, File localAbsPath, File wriAbsPath, File reposRelPath, SVNURL reposRootUrl, String reposUuid, long targetRevision, SVNProperties newPristineProperties, Map<String, SVNProperties> iprops, long changedRev, SVNDate changedDate, String changedAuthor, SvnChecksum newChecksum, SVNProperties davCache, File recordAncestorAbspath, File recordedReposRelPath, long recordedPegRevision, long recordedRevision, boolean updateActualProperties, SVNProperties newActualProperties, boolean keepRecordedInfo, SVNSkel conflictSkel, SVNSkel allWorkItems) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        if (wriAbsPath == null) {
            wriAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        }
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(wriAbsPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        File localRelpath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root.getAbsPath().getAbsolutePath(), localAbsPath.getAbsolutePath()));
        Object externalInfo = Structure.obtain(StructureFields.ExternalNodeInfo.class);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.File);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.presence, (Object)ISVNWCDb.SVNWCDbStatus.Normal);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposRootUrl, reposRootUrl);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposUuid, reposUuid);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposId, -1L);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.reposRelPath, reposRelPath);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.revision, targetRevision);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.properties, newPristineProperties);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.iprops, iprops);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.changedRevision, changedRev);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.changedDate, changedDate);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.changedAuthor, changedAuthor);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.checksum, newChecksum);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.davCache, davCache);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordAncestorRelPath, SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root.getAbsPath().getAbsolutePath(), recordAncestorAbspath.getAbsolutePath())));
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedRevision, recordedRevision);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedPegRevision, recordedPegRevision);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.recordedReposRelPath, recordedReposRelPath);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.updateActualProperties, updateActualProperties);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.newActualProperties, newActualProperties);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.keepRecordedInfo, keepRecordedInfo);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.conflict, conflictSkel);
        ((Structure)externalInfo).set((StructureFields.ExternalNodeInfo)StructureFields.ExternalNodeInfo.workItems, allWorkItems);
        SvnWcDbExternals.begingWriteTransaction(root);
        try {
            try {
                SvnWcDbExternals.insertExternalNode(root, localRelpath, externalInfo);
            }
            catch (SVNException e) {
                SvnWcDbExternals.rollbackTransaction(root);
                throw e;
            }
            Object var34_28 = null;
        }
        catch (Throwable throwable) {
            Object var34_29 = null;
            SvnWcDbExternals.commitTransaction(root);
            ((Structure)externalInfo).release();
            throw throwable;
        }
        SvnWcDbExternals.commitTransaction(root);
        ((Structure)externalInfo).release();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InsertExternalStatement
    extends SVNSqlJetInsertStatement {
        public InsertExternalStatement(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.EXTERNALS, SqlJetConflictAction.REPLACE);
        }

        @Override
        protected Map<String, Object> getInsertValues() throws SVNException {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(SVNWCDbSchema.EXTERNALS__Fields.wc_id.toString(), this.getBind(1));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.local_relpath.toString(), this.getBind(2));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.parent_relpath.toString(), this.getBind(3));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.presence.toString(), this.getBind(4));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.kind.toString(), this.getBind(5));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.def_local_relpath.toString(), this.getBind(6));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.repos_id.toString(), this.getBind(7));
            values.put(SVNWCDbSchema.EXTERNALS__Fields.def_repos_relpath.toString(), this.getBind(8));
            if ((Long)this.getBind(9) >= 0L) {
                values.put(SVNWCDbSchema.EXTERNALS__Fields.def_operational_revision.toString(), this.getBind(9));
            } else {
                values.put(SVNWCDbSchema.EXTERNALS__Fields.def_operational_revision.toString(), null);
            }
            if ((Long)this.getBind(10) >= 0L) {
                values.put(SVNWCDbSchema.EXTERNALS__Fields.def_revision.toString(), this.getBind(10));
            } else {
                values.put(SVNWCDbSchema.EXTERNALS__Fields.def_revision.toString(), null);
            }
            return values;
        }
    }
}

