/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class AbstractSVNMerger
implements ISVNMerger {
    private byte[] myStart;
    private byte[] mySeparator;
    private byte[] myEnd;
    private SVNDiffOptions myDiffOptions;

    protected AbstractSVNMerger(byte[] start, byte[] sep, byte[] end) {
        this.myStart = start;
        this.mySeparator = sep;
        this.myEnd = end;
    }

    protected byte[] getConflictSeparatorMarker() {
        return this.mySeparator;
    }

    protected byte[] getConflictStartMarker() {
        return this.myStart;
    }

    protected byte[] getConflictEndMarker() {
        return this.myEnd;
    }

    protected SVNDiffOptions getDiffOptions() {
        return this.myDiffOptions;
    }

    public SVNMergeResult mergeText(SVNMergeFileSet files, boolean dryRun, SVNDiffOptions options) throws SVNException {
        this.myDiffOptions = options;
        SVNStatusType status = files.isBinary() ? this.mergeBinary(files.getBaseFile(), files.getLocalFile(), files.getRepositoryFile(), options, files.getResultFile()) : this.mergeText(files.getBaseFile(), files.getLocalFile(), files.getRepositoryFile(), options, files.getResultFile());
        if (!files.isBinary() && status != SVNStatusType.CONFLICTED) {
            if (files.getCopyFromFile() != null) {
                status = SVNStatusType.MERGED;
            } else {
                SVNAdminArea adminArea = files.getAdminArea();
                SVNVersionedProperties props = adminArea.getProperties(files.getWCPath());
                boolean isSpecial = props.getPropertyValue("svn:special") != null;
                boolean isSameContents = SVNFileUtil.compareFiles(isSpecial ? files.getLocalFile() : files.getWCFile(), files.getResultFile(), null);
                status = isSameContents ? SVNStatusType.UNCHANGED : status;
            }
        }
        SVNMergeResult result = SVNMergeResult.createMergeResult(status, null);
        if (dryRun) {
            return result;
        }
        return this.processMergedFiles(files, result);
    }

    protected abstract SVNMergeResult processMergedFiles(SVNMergeFileSet var1, SVNMergeResult var2) throws SVNException;

    protected abstract SVNStatusType mergeText(File var1, File var2, File var3, SVNDiffOptions var4, File var5) throws SVNException;

    protected abstract SVNStatusType mergeBinary(File var1, File var2, File var3, SVNDiffOptions var4, File var5) throws SVNException;
}

