/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.server.AbstractAddressingEndpointMapping;

public abstract class AbstractActionEndpointMapping
extends AbstractAddressingEndpointMapping {
    public static final String DEFAULT_OUTPUT_ACTION_SUFFIX = "Response";
    public static final String DEFAULT_FAULT_ACTION_SUFFIX = "Fault";
    private final Map<URI, Object> endpointMap = new HashMap<URI, Object>();
    private String outputActionSuffix = "Response";
    private String faultActionSuffix = "Response";

    public String getOutputActionSuffix() {
        return this.outputActionSuffix;
    }

    public void setOutputActionSuffix(String outputActionSuffix) {
        Assert.hasText((String)outputActionSuffix, (String)"'outputActionSuffix' must not be empty");
        this.outputActionSuffix = outputActionSuffix;
    }

    public String getFaultActionSuffix() {
        return this.faultActionSuffix;
    }

    public void setFaultActionSuffix(String faultActionSuffix) {
        Assert.hasText((String)faultActionSuffix, (String)"'faultActionSuffix' must not be empty");
        this.faultActionSuffix = faultActionSuffix;
    }

    @Override
    protected final Object getEndpointInternal(MessageAddressingProperties map) {
        URI endpointAddress;
        Object endpoint;
        URI action = map.getAction();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up endpoint for action [" + action + "]"));
        }
        if ((endpoint = this.lookupEndpoint(action)) != null && ((endpointAddress = this.getEndpointAddress(endpoint)) == null || endpointAddress.equals(map.getTo()))) {
            return endpoint;
        }
        return null;
    }

    protected abstract URI getEndpointAddress(Object var1);

    protected Object lookupEndpoint(URI action) {
        return this.endpointMap.get(action);
    }

    protected void registerEndpoint(URI action, Object endpoint) throws BeansException, IllegalStateException {
        Object mappedEndpoint;
        Assert.notNull((Object)action, (String)"Action must not be null");
        Assert.notNull((Object)endpoint, (String)"Endpoint object must not be null");
        Object resolvedEndpoint = endpoint;
        if (endpoint instanceof String) {
            String endpointName = (String)endpoint;
            if (this.getApplicationContext().isSingleton(endpointName)) {
                resolvedEndpoint = this.getApplicationContext().getBean(endpointName);
            }
        }
        if ((mappedEndpoint = this.endpointMap.get(action)) != null) {
            if (mappedEndpoint != resolvedEndpoint) {
                throw new IllegalStateException("Cannot map endpoint [" + endpoint + "] to action [" + action + "]: There is already endpoint [" + resolvedEndpoint + "] mapped.");
            }
        } else {
            this.endpointMap.put(action, resolvedEndpoint);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapped Action [" + action + "] onto endpoint [" + resolvedEndpoint + "]"));
            }
        }
    }

    @Override
    protected URI getResponseAction(Object endpoint, MessageAddressingProperties requestMap) {
        URI requestAction = requestMap.getAction();
        if (requestAction != null) {
            return URI.create(requestAction.toString() + this.getOutputActionSuffix());
        }
        return null;
    }

    @Override
    protected URI getFaultAction(Object endpoint, MessageAddressingProperties requestMap) {
        URI requestAction = requestMap.getAction();
        if (requestAction != null) {
            return URI.create(requestAction.toString() + this.getFaultActionSuffix());
        }
        return null;
    }
}

