/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.support.BufferingClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class LoggingErrorHandler
extends DefaultResponseErrorHandler {
    private static final Log LOG = LogFactory.getLog(LoggingErrorHandler.class);

    public void handleError(ClientHttpResponse response) throws IOException {
        BufferingClientHttpResponse bufferedResponse = new BufferingClientHttpResponse(response);
        InputStream bodyStream = bufferedResponse.getBody();
        BufferedReader reader = new BufferedReader(new InputStreamReader(bodyStream));
        StringBuffer buffer = new StringBuffer();
        while (reader.ready()) {
            buffer.append(reader.readLine());
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Response body: " + buffer.toString()));
        }
        super.handleError((ClientHttpResponse)bufferedResponse);
    }
}

