/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.OAuth1Connection;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1ServiceProvider;
import org.springframework.social.oauth1.OAuthToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth1ConnectionFactory<A>
extends ConnectionFactory<A> {
    public OAuth1ConnectionFactory(String providerId, OAuth1ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(providerId, serviceProvider, apiAdapter);
    }

    public OAuth1Operations getOAuthOperations() {
        return this.getOAuth1ServiceProvider().getOAuthOperations();
    }

    public Connection<A> createConnection(OAuthToken accessToken) {
        String providerUserId = this.extractProviderUserId(accessToken);
        return new OAuth1Connection<A>(this.getProviderId(), providerUserId, accessToken.getValue(), accessToken.getSecret(), this.getOAuth1ServiceProvider(), this.getApiAdapter());
    }

    @Override
    public Connection<A> createConnection(ConnectionData data) {
        return new OAuth1Connection<A>(data, this.getOAuth1ServiceProvider(), this.getApiAdapter());
    }

    protected String extractProviderUserId(OAuthToken accessToken) {
        return null;
    }

    private OAuth1ServiceProvider<A> getOAuth1ServiceProvider() {
        return (OAuth1ServiceProvider)this.getServiceProvider();
    }
}

