/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2AuthorizationRequest
implements Serializable {
    private static final long serialVersionUID = 510L;
    private String authorizationUri;
    private AuthorizationGrantType authorizationGrantType;
    private OAuth2AuthorizationResponseType responseType;
    private String clientId;
    private String redirectUri;
    private Set<String> scopes;
    private String state;
    private Map<String, Object> additionalParameters;
    private String authorizationRequestUri;

    private OAuth2AuthorizationRequest() {
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public AuthorizationGrantType getGrantType() {
        return this.authorizationGrantType;
    }

    public OAuth2AuthorizationResponseType getResponseType() {
        return this.responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getState() {
        return this.state;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public String getAuthorizationRequestUri() {
        return this.authorizationRequestUri;
    }

    public static Builder authorizationCode() {
        return new Builder(AuthorizationGrantType.AUTHORIZATION_CODE);
    }

    public static Builder implicit() {
        return new Builder(AuthorizationGrantType.IMPLICIT);
    }

    public static Builder from(OAuth2AuthorizationRequest authorizationRequest) {
        Assert.notNull((Object)authorizationRequest, (String)"authorizationRequest cannot be null");
        return new Builder(authorizationRequest.getGrantType()).authorizationUri(authorizationRequest.getAuthorizationUri()).clientId(authorizationRequest.getClientId()).redirectUri(authorizationRequest.getRedirectUri()).scopes(authorizationRequest.getScopes()).state(authorizationRequest.getState()).additionalParameters(authorizationRequest.getAdditionalParameters());
    }

    public static class Builder {
        private String authorizationUri;
        private AuthorizationGrantType authorizationGrantType;
        private OAuth2AuthorizationResponseType responseType;
        private String clientId;
        private String redirectUri;
        private Set<String> scopes;
        private String state;
        private Map<String, Object> additionalParameters;
        private String authorizationRequestUri;

        private Builder(AuthorizationGrantType authorizationGrantType) {
            Assert.notNull((Object)authorizationGrantType, (String)"authorizationGrantType cannot be null");
            this.authorizationGrantType = authorizationGrantType;
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals(authorizationGrantType)) {
                this.responseType = OAuth2AuthorizationResponseType.CODE;
            } else if (AuthorizationGrantType.IMPLICIT.equals(authorizationGrantType)) {
                this.responseType = OAuth2AuthorizationResponseType.TOKEN;
            }
        }

        public Builder authorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder scope(String ... scope) {
            if (scope != null && scope.length > 0) {
                return this.scopes(Arrays.stream(scope).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            return this;
        }

        public Builder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder additionalParameters(Map<String, Object> additionalParameters) {
            this.additionalParameters = additionalParameters;
            return this;
        }

        public Builder authorizationRequestUri(String authorizationRequestUri) {
            this.authorizationRequestUri = authorizationRequestUri;
            return this;
        }

        public OAuth2AuthorizationRequest build() {
            Assert.hasText((String)this.authorizationUri, (String)"authorizationUri cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            if (AuthorizationGrantType.IMPLICIT.equals(this.authorizationGrantType)) {
                Assert.hasText((String)this.redirectUri, (String)"redirectUri cannot be empty");
            }
            OAuth2AuthorizationRequest authorizationRequest = new OAuth2AuthorizationRequest();
            authorizationRequest.authorizationUri = this.authorizationUri;
            authorizationRequest.authorizationGrantType = this.authorizationGrantType;
            authorizationRequest.responseType = this.responseType;
            authorizationRequest.clientId = this.clientId;
            authorizationRequest.redirectUri = this.redirectUri;
            authorizationRequest.state = this.state;
            authorizationRequest.scopes = Collections.unmodifiableSet(CollectionUtils.isEmpty(this.scopes) ? Collections.emptySet() : new LinkedHashSet<String>(this.scopes));
            authorizationRequest.additionalParameters = Collections.unmodifiableMap(CollectionUtils.isEmpty(this.additionalParameters) ? Collections.emptyMap() : new LinkedHashMap<String, Object>(this.additionalParameters));
            authorizationRequest.authorizationRequestUri = StringUtils.hasText((String)this.authorizationRequestUri) ? this.authorizationRequestUri : this.buildAuthorizationRequestUri();
            return authorizationRequest;
        }

        private String buildAuthorizationRequestUri() {
            LinkedMultiValueMap parameters = new LinkedMultiValueMap();
            parameters.set((Object)"response_type", (Object)this.responseType.getValue());
            parameters.set((Object)"client_id", (Object)this.clientId);
            if (!CollectionUtils.isEmpty(this.scopes)) {
                parameters.set((Object)"scope", (Object)StringUtils.collectionToDelimitedString(this.scopes, (String)" "));
            }
            if (this.state != null) {
                parameters.set((Object)"state", (Object)this.state);
            }
            if (this.redirectUri != null) {
                parameters.set((Object)"redirect_uri", (Object)this.redirectUri);
            }
            if (!CollectionUtils.isEmpty(this.additionalParameters)) {
                this.additionalParameters.entrySet().stream().filter(e -> !((String)e.getKey()).equals("registration_id")).forEach(arg_0 -> Builder.lambda$buildAuthorizationRequestUri$1((MultiValueMap)parameters, arg_0));
            }
            return UriComponentsBuilder.fromHttpUrl((String)this.authorizationUri).queryParams((MultiValueMap)parameters).encode(StandardCharsets.UTF_8).build().toUriString();
        }

        private static /* synthetic */ void lambda$buildAuthorizationRequestUri$1(MultiValueMap parameters, Map.Entry e) {
            parameters.set(e.getKey(), (Object)e.getValue().toString());
        }
    }
}

